/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.primitives.Ints;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.type.IntegralArrayType;

public class IntegerArrayType
extends IntegralArrayType<int[], Integer> {
    private static final long serialVersionUID = 2097437088172327725L;

    public IntegerArrayType() {
        super(FieldTypeRegistry.INTEGER, int[].class);
    }

    @Override
    protected int getArrayLength(int[] array) {
        return array.length;
    }

    @Override
    protected Integer getArrayElement(int[] array, int index) {
        return array[index];
    }

    @Override
    protected int[] createArray(List<Integer> elements) {
        return Ints.toArray(elements);
    }

    @Override
    protected void encode(int[] array, DataOutputStream output) throws IOException {
        for (int value : array) {
            output.writeInt(value);
        }
    }

    @Override
    protected int[] decode(DataInputStream input, int numBytes) throws IOException {
        int[] array = (int[])this.checkDecodeLength(numBytes);
        for (int i = 0; i < array.length; ++i) {
            array[i] = input.readInt();
        }
        return array;
    }
}

