/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.time.LocalTime;
import java.util.regex.Pattern;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.ParseContext;

public class LocalTimeType
extends NonNullFieldType<LocalTime> {
    static final Pattern PATTERN = Pattern.compile("[0-9]+:[0-9]+(:[0-9]+(\\.[0-9]+)?)?");
    private static final long serialVersionUID = -6138317689607411426L;

    public LocalTimeType() {
        super(LocalTime.class, 0L);
    }

    @Override
    public LocalTime read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return LocalTime.ofNanoOfDay(LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, LocalTime localTime) {
        Preconditions.checkArgument((localTime != null ? 1 : 0) != 0, (Object)"null localTime");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)localTime.toNanoOfDay());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public LocalTime fromParseableString(ParseContext ctx) {
        return LocalTime.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(LocalTime localTime) {
        return localTime.toString();
    }

    @Override
    public int compare(LocalTime localTime1, LocalTime localTime2) {
        return localTime1.compareTo(localTime2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

