/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public class NullSafeType<T>
extends FieldType<T> {
    public static final int NOT_NULL_SENTINEL = 1;
    public static final int NULL_SENTINEL = 255;
    private static final long serialVersionUID = -6420381330755516561L;
    protected final FieldType<T> inner;
    private final boolean inline;

    public NullSafeType(String name, FieldType<T> inner) {
        super(name, inner.getTypeToken().wrap(), inner.getEncodingSignature(), null);
        Preconditions.checkArgument((!(inner instanceof NullSafeType) ? 1 : 0) != 0, (Object)"inner type is already null-safe");
        this.inner = inner;
        this.inline = !inner.hasPrefix0xff();
    }

    public NullSafeType(FieldType<T> inner) {
        this(inner.getName(), inner);
    }

    @Override
    public T read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        if (this.inline) {
            if (reader.peek() == 255) {
                reader.skip(1);
                return null;
            }
            return this.inner.read(reader);
        }
        switch (reader.readByte()) {
            case 255: {
                return null;
            }
            case 1: {
                return this.inner.read(reader);
            }
        }
        throw new IllegalArgumentException("invalid encoding of " + this);
    }

    @Override
    public void write(ByteWriter writer, T value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        if (value == null) {
            writer.writeByte(255);
            return;
        }
        if (!this.inline) {
            writer.writeByte(1);
        }
        this.inner.write(writer, value);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        if (this.inline) {
            int prefix = reader.peek();
            switch (prefix) {
                case 255: {
                    reader.skip(1);
                    break;
                }
                default: {
                    this.inner.skip(reader);
                    break;
                }
            }
        } else {
            int prefix = reader.readByte();
            switch (prefix) {
                case 255: {
                    break;
                }
                case 1: {
                    this.inner.skip(reader);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid encoding of " + this);
                }
            }
        }
    }

    @Override
    public T fromString(String string) {
        return this.inner.fromString(string);
    }

    @Override
    public String toString(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        return this.inner.toString(value);
    }

    @Override
    public T fromParseableString(ParseContext context) {
        return context.tryPattern("null\\b") != null ? null : (T)this.inner.fromParseableString(context);
    }

    @Override
    public String toParseableString(T value) {
        return value == null ? "null" : this.inner.toParseableString(value);
    }

    @Override
    public <S> T convert(FieldType<S> type, S value) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        return value == null ? null : (T)this.inner.convert(type, value);
    }

    @Override
    public int compare(T value1, T value2) {
        if (value1 == null) {
            return value2 == null ? 0 : 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this.inner.compare(value1, value2);
    }

    @Override
    public boolean hasPrefix0xff() {
        return true;
    }

    @Override
    public boolean hasPrefix0x00() {
        return this.inline && this.inner.hasPrefix0x00();
    }

    @Override
    public NullSafeType<T> genericizeForIndex() {
        return new NullSafeType<T>(this.inner.genericizeForIndex());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.inner.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NullSafeType that = (NullSafeType)obj;
        return this.inner.equals(that.inner);
    }
}

