/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jsimpledb.core.type.Concat2Type;
import org.jsimpledb.core.type.InstantType;
import org.jsimpledb.core.type.LocalDateTimeType;
import org.jsimpledb.core.type.ZoneOffsetType;
import org.jsimpledb.util.ParseContext;

public class OffsetDateTimeType
extends Concat2Type<OffsetDateTime, Instant, ZoneOffset> {
    private static final long serialVersionUID = -1216769026293613698L;

    public OffsetDateTimeType() {
        super(OffsetDateTime.class, 0L, new InstantType(), new ZoneOffsetType());
    }

    @Override
    protected OffsetDateTime join(Instant value1, ZoneOffset value2) {
        return OffsetDateTime.ofInstant(value1, value2);
    }

    @Override
    protected Instant split1(OffsetDateTime value) {
        return value.toInstant();
    }

    @Override
    protected ZoneOffset split2(OffsetDateTime value) {
        return value.getOffset();
    }

    @Override
    public OffsetDateTime fromParseableString(ParseContext ctx) {
        return OffsetDateTime.parse(ctx.matchPrefix(LocalDateTimeType.PATTERN).group() + ctx.matchPrefix(ZoneOffsetType.PATTERN).group());
    }

    @Override
    public String toParseableString(OffsetDateTime offsetDateTime) {
        return offsetDateTime.toString();
    }
}

