/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.jsimpledb.core.type.Concat2Type;
import org.jsimpledb.core.type.LocalTimeType;
import org.jsimpledb.core.type.LongType;
import org.jsimpledb.core.type.ZoneOffsetType;
import org.jsimpledb.util.ParseContext;

public class OffsetTimeType
extends Concat2Type<OffsetTime, Long, ZoneOffset> {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    private static final long serialVersionUID = -42507926581583354L;

    public OffsetTimeType() {
        super(OffsetTime.class, 0L, new LongType(), new ZoneOffsetType());
    }

    @Override
    protected OffsetTime join(Long value1, ZoneOffset value2) {
        return OffsetTime.of(LocalTime.ofNanoOfDay(value1 + (long)value2.getTotalSeconds() * 1000000000L), value2);
    }

    @Override
    protected Long split1(OffsetTime value) {
        return value.toLocalTime().toNanoOfDay() - (long)value.getOffset().getTotalSeconds() * 1000000000L;
    }

    @Override
    protected ZoneOffset split2(OffsetTime value) {
        return value.getOffset();
    }

    @Override
    public OffsetTime fromParseableString(ParseContext ctx) {
        return OffsetTime.parse(ctx.matchPrefix(LocalTimeType.PATTERN).group() + ctx.matchPrefix(ZoneOffsetType.PATTERN).group());
    }

    @Override
    public String toParseableString(OffsetTime offsetTime) {
        return offsetTime.toString();
    }
}

