/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.dellroad.stuff.string.StringEncoder;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.core.type.StringType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public class StringConvertedType<T>
extends NonNullFieldType<T> {
    private static final long serialVersionUID = -2432755812735736593L;
    private final StringType stringType = new StringType();
    private final Converter<T, String> converter;

    protected StringConvertedType(String name, TypeToken<T> type, long signature, Converter<T, String> converter) {
        super(name, type, signature);
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        Preconditions.checkArgument((converter.convert(null) == null && converter.reverse().convert(null) == null ? 1 : 0) != 0, (Object)"invalid converter: does not convert null <-> null");
        this.converter = converter;
    }

    @Override
    public T read(ByteReader reader) {
        String string;
        try {
            string = this.stringType.read(reader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid encoded " + this.getName(), e);
        }
        return (T)this.converter.reverse().convert((Object)string);
    }

    @Override
    public void write(ByteWriter writer, T obj) {
        this.stringType.write(writer, (String)this.converter.convert(obj));
    }

    @Override
    public void skip(ByteReader reader) {
        this.stringType.skip(reader);
    }

    @Override
    public String toString(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("illegal null " + this.getName());
        }
        return (String)this.converter.convert(obj);
    }

    @Override
    public T fromString(String string) {
        try {
            return (T)this.converter.reverse().convert((Object)string);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("conversion from String failed", e);
        }
    }

    @Override
    public String toParseableString(T obj) {
        return StringEncoder.enquote((String)this.toString(obj));
    }

    @Override
    public T fromParseableString(ParseContext ctx) {
        return this.fromString(StringEncoder.dequote((String)ctx.matchPrefix(StringEncoder.ENQUOTE_PATTERN).group()));
    }

    @Override
    public int compare(T obj1, T obj2) {
        return this.stringType.compare(this.toString(obj1), this.toString(obj2));
    }

    @Override
    public boolean hasPrefix0x00() {
        return this.stringType.hasPrefix0x00();
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.stringType.hasPrefix0xff();
    }
}

