/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.tuple.Tuple;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public abstract class TupleFieldType<T extends Tuple>
extends NonNullFieldType<T> {
    private static final long serialVersionUID = 8691368371643936848L;
    final List<FieldType<?>> fieldTypes;
    final int size;

    protected TupleFieldType(TypeToken<T> typeToken, FieldType<?> ... fieldTypes) {
        super("Tuple" + fieldTypes.length, typeToken, TupleFieldType.hashEncodingSignatures(fieldTypes));
        this.fieldTypes = Arrays.asList(fieldTypes);
        this.size = this.fieldTypes.size();
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public T read(ByteReader reader) {
        Object[] values = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            values[i] = this.fieldTypes.get(i).read(reader);
        }
        return this.createTuple(values);
    }

    @Override
    public void write(ByteWriter writer, T tuple) {
        List<Object> values = this.asList((Tuple)tuple);
        for (int i = 0; i < this.size; ++i) {
            this.fieldTypes.get(i).validateAndWrite(writer, values.get(i));
        }
    }

    @Override
    public void skip(ByteReader reader) {
        for (FieldType<?> fieldType : this.fieldTypes) {
            fieldType.skip(reader);
        }
    }

    @Override
    public String toParseableString(T tuple) {
        List<Object> values = this.asList((Tuple)tuple);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toParseableString(this.fieldTypes.get(i), values.get(i)));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public T fromParseableString(ParseContext context) {
        context.expect('[');
        Object[] values = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                context.expect(',');
            }
            values[i] = this.fieldTypes.get(i).fromParseableString(context);
        }
        context.expect(']');
        return this.createTuple(values);
    }

    @Override
    public int compare(Tuple tuple1, Tuple tuple2) {
        List<Object> values1 = this.asList(tuple1);
        List<Object> values2 = this.asList(tuple2);
        for (int i = 0; i < this.size; ++i) {
            int diff = this.compare(this.fieldTypes.get(i), values1.get(i), values2.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.fieldTypes.get(0).hasPrefix0xff();
    }

    @Override
    public boolean hasPrefix0x00() {
        return this.fieldTypes.get(0).hasPrefix0x00();
    }

    protected abstract T createTuple(Object[] var1);

    private List<Object> asList(Tuple tuple) {
        Preconditions.checkArgument((tuple != null ? 1 : 0) != 0, (Object)"null tuple");
        List list = tuple.asList();
        if (list.size() != this.size) {
            throw new IllegalArgumentException("tuple has the wrong cardinality " + list.size() + " != " + this.size);
        }
        return list;
    }

    private static long hashEncodingSignatures(FieldType<?> ... fieldTypes) {
        long hash = 0L;
        for (FieldType<?> fieldType : fieldTypes) {
            hash = hash * 65537L + fieldType.getEncodingSignature();
        }
        return hash;
    }

    private <T> String toParseableString(FieldType<T> fieldType, Object obj) {
        return fieldType.toParseableString(fieldType.validate(obj));
    }

    private <T> int compare(FieldType<T> fieldType, Object obj1, Object obj2) {
        return fieldType.compare(fieldType.validate(obj1), fieldType.validate(obj2));
    }
}

