/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public class UUIDType
extends NonNullFieldType<UUID> {
    private static final long serialVersionUID = -7426558458120883995L;
    private static final long MASK = Long.MIN_VALUE;
    private static final String PATTERN = "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";

    public UUIDType() {
        super(UUID.class, 0L);
    }

    @Override
    public UUID read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return new UUID(ByteUtil.readLong((ByteReader)reader) ^ Long.MIN_VALUE, ByteUtil.readLong((ByteReader)reader) ^ Long.MIN_VALUE);
    }

    @Override
    public void write(ByteWriter writer, UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"null uuid");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        ByteUtil.writeLong((ByteWriter)writer, (long)(uuid.getMostSignificantBits() ^ Long.MIN_VALUE));
        ByteUtil.writeLong((ByteWriter)writer, (long)(uuid.getLeastSignificantBits() ^ Long.MIN_VALUE));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(16);
    }

    @Override
    public UUID fromParseableString(ParseContext ctx) {
        return UUID.fromString(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(UUID uuid) {
        return uuid.toString();
    }

    @Override
    public int compare(UUID uuid1, UUID uuid2) {
        return uuid1.compareTo(uuid2);
    }
}

