/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;
import org.jsimpledb.util.UnsignedIntEncoder;

public class UnsignedIntType
extends NonNullFieldType<Integer> {
    private static final long serialVersionUID = 4653435311425384497L;

    public UnsignedIntType() {
        super("uint", TypeToken.of(Integer.class), 0L, 0);
    }

    @Override
    public Integer read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return UnsignedIntEncoder.read((ByteReader)reader);
    }

    @Override
    public void write(ByteWriter writer, Integer value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)value);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(UnsignedIntEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public String toParseableString(Integer value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        return String.valueOf(value);
    }

    @Override
    public Integer fromParseableString(ParseContext ctx) {
        return (Integer)Primitive.INTEGER.parseValue(ctx.matchPrefix(Primitive.INTEGER.getParsePattern()).group());
    }

    @Override
    public int compare(Integer value1, Integer value2) {
        return Integer.compare(value1, value2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return true;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

