/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import org.jsimpledb.core.type.Concat2Type;
import org.jsimpledb.core.type.OffsetDateTimeType;
import org.jsimpledb.core.type.ZoneIdType;
import org.jsimpledb.util.ParseContext;

public class ZonedDateTimeType
extends Concat2Type<ZonedDateTime, OffsetDateTime, ZoneId> {
    private static final long serialVersionUID = 2484375470437659420L;

    public ZonedDateTimeType() {
        super(ZonedDateTime.class, 0L, new OffsetDateTimeType(), new ZoneIdType());
    }

    @Override
    protected ZonedDateTime join(OffsetDateTime value1, ZoneId value2) {
        return ZonedDateTime.ofInstant(value1.toInstant(), value2);
    }

    @Override
    protected OffsetDateTime split1(ZonedDateTime value) {
        return value.toOffsetDateTime();
    }

    @Override
    protected ZoneId split2(ZonedDateTime value) {
        return value.getZone();
    }

    @Override
    public ZonedDateTime fromParseableString(ParseContext ctx) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)this.type1.fromParseableString(ctx);
        Matcher matcher = ctx.tryPattern("\\[(.+)\\]");
        ZoneOffset zoneId = matcher != null ? (ZoneId)this.type2.fromString(matcher.group(1)) : offsetDateTime.getOffset();
        return ZonedDateTime.ofInstant(offsetDateTime.toInstant(), zoneId);
    }

    @Override
    public String toParseableString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toString();
    }
}

