/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;

@ThreadSafe
public class GeneratedIdCache {
    @GuardedBy(value="this")
    private final HashMap<String, ObjId> map = new HashMap();

    public synchronized ObjId getGeneratedId(Transaction tx, int storageId, String string) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"null string");
        String key = "" + storageId + ":" + string;
        ObjId id = this.map.get(key);
        if (id == null) {
            id = tx.generateId(storageId);
            this.map.put(key, id);
        }
        return id;
    }

    public synchronized void clear() {
        this.map.clear();
    }
}

