/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.util;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import org.jsimpledb.core.CounterField;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitchAdapter;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.StaleTransactionException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.UnknownTypeException;

public final class ObjDumper {
    private ObjDumper() {
    }

    public static String toString(Transaction tx, ObjId id, int maxCollectionEntries) {
        ObjType type;
        Schema schema;
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        try {
            schema = tx.getSchemas().getVersion(tx.getSchemaVersion(id));
        }
        catch (IllegalArgumentException | DeletedObjectException | StaleTransactionException e) {
            schema = tx.getSchema();
        }
        try {
            type = schema.getObjType(id.getStorageId());
        }
        catch (UnknownTypeException e) {
            return "type#" + id.getStorageId() + "@" + id;
        }
        if (!tx.isValid()) {
            return type.getName() + "@" + id + " [stale tx]";
        }
        StringWriter buf = new StringWriter();
        try {
            ObjDumper.print(new PrintWriter(buf), tx, id, maxCollectionEntries);
        }
        catch (Exception e) {
            buf.write("[exception reading " + type.getName() + "@" + id + ": " + e + "]");
        }
        return buf.toString().trim();
    }

    public static void print(final PrintWriter writer, final Transaction tx, final ObjId id, final int maxCollectionEntries) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        int schemaVersion = tx.getSchemaVersion(id);
        Schema schema = tx.getSchemas().getVersion(schemaVersion);
        ObjType type = schema.getObjType(id.getStorageId());
        writer.println("object " + id + " type " + type.getName() + "#" + type.getStorageId() + " version " + schemaVersion);
        int nameFieldSize = 0;
        for (Field<?> field : type.getFields().values()) {
            nameFieldSize = Math.max(nameFieldSize, field.getName().length());
        }
        char[] ichars = new char[nameFieldSize + 3];
        Arrays.fill(ichars, ' ');
        final String indent = new String(ichars);
        final String eindent = indent + "  ";
        for (Field<?> field : type.getFields().values()) {
            writer.print(String.format("%" + nameFieldSize + "s = ", field.getName()));
            field.visit(new FieldSwitchAdapter<Void>(){

                @Override
                public <T> Void caseSimpleField(SimpleField<T> field) {
                    FieldType<T> fieldType = field.getFieldType();
                    writer.println(fieldType.toParseableString(fieldType.validate(tx.readSimpleField(id, field.getStorageId(), false))));
                    return null;
                }

                @Override
                public Void caseCounterField(CounterField field) {
                    writer.println("" + tx.readCounterField(id, field.getStorageId(), false));
                    return null;
                }

                @Override
                public <E> Void caseSetField(SetField<E> field) {
                    this.handleCollection(tx.readSetField(id, field.getStorageId(), false), field.getElementField(), false);
                    return null;
                }

                @Override
                public <E> Void caseListField(ListField<E> field) {
                    this.handleCollection(tx.readListField(id, field.getStorageId(), false), field.getElementField(), true);
                    return null;
                }

                private <E> void handleCollection(Collection<E> items, SimpleField<E> elementField, boolean showIndex) {
                    FieldType<E> fieldType = elementField.getFieldType();
                    writer.println("{");
                    int count = 0;
                    for (E item : items) {
                        if (count >= maxCollectionEntries) {
                            writer.println(eindent + "...");
                            break;
                        }
                        writer.print(eindent);
                        if (showIndex) {
                            writer.print("[" + count + "] ");
                        }
                        writer.println(fieldType.toParseableString(item));
                        ++count;
                    }
                    writer.println(indent + "}");
                }

                @Override
                public <K, V> Void caseMapField(MapField<K, V> field) {
                    FieldType<K> keyFieldType = field.getKeyField().getFieldType();
                    FieldType<V> valueFieldType = field.getValueField().getFieldType();
                    writer.println("{");
                    int count = 0;
                    NavigableMap<?, ?> map = tx.readMapField(id, field.getStorageId(), false);
                    for (Map.Entry entry : map.entrySet()) {
                        if (count >= maxCollectionEntries) {
                            writer.println(eindent + "...");
                            break;
                        }
                        writer.println(eindent + keyFieldType.toParseableString(entry.getKey()) + " -> " + valueFieldType.toParseableString(entry.getValue()));
                        ++count;
                    }
                    writer.println(indent + "}");
                    return null;
                }
            });
        }
        writer.flush();
    }
}

