/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.ObjIdSet;

@NotThreadSafe
public class ObjIdMap<V>
extends AbstractMap<ObjId, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4931628136892145403L;
    private static final float EXPAND_THRESHOLD = 0.7f;
    private static final float SHRINK_THRESHOLD = 0.25f;
    private static final int MIN_LOG2_LENGTH = 4;
    private static final int MAX_LOG2_LENGTH = 30;
    private long[] keys;
    private V[] values;
    private int size;
    private int log2len;
    private int upperSizeLimit;
    private int lowerSizeLimit;
    private int numHashShifts;
    private volatile int modcount;

    public ObjIdMap() {
        this(0, true);
    }

    public ObjIdMap(int capacity) {
        this(capacity, true);
    }

    public ObjIdMap(Map<ObjId, ? extends V> map) {
        this(map.size(), true);
        for (Map.Entry<ObjId, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    ObjIdMap(int capacity, boolean withValues) {
        Preconditions.checkArgument((capacity >= 0 ? 1 : 0) != 0, (Object)"capacity < 0");
        capacity &= 0x3FFFFFFF;
        capacity = (int)((float)capacity / 0.7f);
        capacity = Math.max(1, capacity);
        this.log2len = 32 - Integer.numberOfLeadingZeros(capacity - 1);
        this.log2len = Math.max(4, this.log2len);
        this.log2len = Math.min(30, this.log2len);
        this.createArrays(withValues);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object obj) {
        if (!(obj instanceof ObjId)) {
            return false;
        }
        long value = ((ObjId)obj).asLong();
        assert (value != 0L);
        int slot = this.findSlot(value);
        if (this.keys[slot] == value) {
            return true;
        }
        assert (this.keys[slot] == 0L);
        return false;
    }

    @Override
    public V get(Object obj) {
        if (!(obj instanceof ObjId)) {
            return null;
        }
        long value = ((ObjId)obj).asLong();
        assert (value != 0L);
        int slot = this.findSlot(value);
        if (this.keys[slot] == value) {
            return this.values != null ? (V)this.values[slot] : null;
        }
        assert (this.keys[slot] == 0L);
        return null;
    }

    @Override
    public V put(ObjId id, V value) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        long key = id.asLong();
        assert (key != 0L);
        return this.insert(key, value);
    }

    @Override
    public V remove(Object obj) {
        if (!(obj instanceof ObjId)) {
            return null;
        }
        long key = ((ObjId)obj).asLong();
        assert (key != 0L);
        return this.exsert(key);
    }

    @Override
    public void clear() {
        this.log2len = 4;
        this.createArrays(this.values != null);
        this.size = 0;
        ++this.modcount;
    }

    public ObjIdSet keySet() {
        return new ObjIdSet(this);
    }

    @Override
    public Set<Map.Entry<ObjId, V>> entrySet() {
        return new EntrySet();
    }

    public Map.Entry<ObjId, V> removeOne() {
        return this.removeOne(this.modcount * 11171);
    }

    private Map.Entry<ObjId, V> removeOne(int offset) {
        if (this.size == 0) {
            return null;
        }
        int mask = (1 << this.log2len) - 1;
        for (int i = 0; i < this.keys.length; ++i) {
            int slot = offset + i & mask;
            if (this.keys[slot] == 0L) continue;
            Entry entry = new Entry(slot);
            this.exsert(slot);
            return entry;
        }
        return null;
    }

    String debugDump() {
        StringBuilder buf = new StringBuilder();
        buf.append("OBJIDMAP: size=" + this.size + " len=" + this.keys.length + " modcount=" + this.modcount);
        for (int i = 0; i < this.keys.length; ++i) {
            buf.append('\n').append(String.format(" [%2d] %016x (hash %d)", i, this.keys[i], this.hash(this.keys[i])));
        }
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public ObjIdMap<V> clone() {
        ObjIdMap clone;
        try {
            clone = (ObjIdMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.keys = (long[])clone.keys.clone();
        if (clone.values != null) {
            clone.values = (Object[])clone.values.clone();
        }
        return clone;
    }

    long[] getKeys() {
        return this.keys;
    }

    V getValue(int slot) {
        return this.values[slot];
    }

    void setValue(int slot, V value) {
        this.values[slot] = value;
    }

    ObjId[] toKeysArray() {
        ObjId[] array = new ObjId[this.size];
        int index = 0;
        for (long value : this.keys) {
            if (value == 0L) continue;
            array[index++] = new ObjId(value);
        }
        return array;
    }

    private V insert(long key, V value) {
        assert (key != 0L);
        int slot = this.findSlot(key);
        if (this.keys[slot] == key) {
            if (this.values == null) {
                return null;
            }
            V prev = this.values[slot];
            this.values[slot] = value;
            return prev;
        }
        assert (this.keys[slot] == 0L);
        this.keys[slot] = key;
        if (this.values != null) {
            assert (this.values[slot] == null);
            this.values[slot] = value;
        }
        if (++this.size > this.upperSizeLimit && this.log2len < 30) {
            ++this.log2len;
            this.resize();
        }
        ++this.modcount;
        return null;
    }

    private V exsert(long key) {
        int slot = this.findSlot(key);
        if (this.keys[slot] == 0L) {
            assert (this.values == null || this.values[slot] == null);
            return null;
        }
        assert (this.keys[slot] == key);
        return this.exsert(slot);
    }

    private V exsert(int slot) {
        assert (this.keys[slot] != 0L);
        V ovalue = this.values != null ? (V)this.values[slot] : null;
        int i = slot;
        int j = slot;
        block0: while (true) {
            long jkey;
            this.keys[i] = 0L;
            if (this.values != null) {
                this.values[i] = null;
            }
            while ((jkey = this.keys[j = j + 1 & this.keys.length - 1]) != 0L) {
                Object jvalue = this.values != null ? this.values[j] : null;
                int k = this.hash(jkey);
                if (i <= j ? i < k && k <= j : i < k || k <= j) continue;
                this.keys[i] = jkey;
                if (this.values != null) {
                    this.values[i] = jvalue;
                }
                i = j;
                continue block0;
            }
            break;
        }
        if (--this.size < this.lowerSizeLimit && this.log2len > 4) {
            --this.log2len;
            this.resize();
        }
        ++this.modcount;
        return ovalue;
    }

    private int findSlot(long value) {
        assert (value != 0L);
        int slot = this.hash(value);
        long existing;
        while ((existing = this.keys[slot]) != 0L && existing != value) {
            slot = slot + 1 & this.keys.length - 1;
        }
        return slot;
    }

    private int hash(long value) {
        int shift = this.log2len;
        int hash = (int)value;
        for (int i = 0; i < this.numHashShifts; ++i) {
            hash ^= (int)(value >>>= shift);
        }
        return hash & this.keys.length - 1;
    }

    private void resize() {
        long[] oldKeys = this.keys;
        V[] oldValues = this.values;
        assert (oldValues == null || oldValues.length == oldKeys.length);
        this.createArrays(oldValues != null);
        for (int oldSlot = 0; oldSlot < oldKeys.length; ++oldSlot) {
            long key = oldKeys[oldSlot];
            if (key == 0L) {
                assert (oldValues == null || oldValues[oldSlot] == null);
                continue;
            }
            int newSlot = this.findSlot(key);
            assert (this.keys[newSlot] == 0L);
            this.keys[newSlot] = key;
            if (this.values == null) continue;
            assert (this.values[newSlot] == null);
            this.values[newSlot] = oldValues[oldSlot];
        }
    }

    private void createArrays(boolean withValues) {
        assert (this.log2len >= 4);
        assert (this.log2len <= 30);
        int arrayLength = 1 << this.log2len;
        this.lowerSizeLimit = this.log2len > 4 ? (int)(0.25f * (float)arrayLength) : 0;
        this.upperSizeLimit = this.log2len < 30 ? (int)(0.7f * (float)arrayLength) : arrayLength;
        this.numHashShifts = (64 + (this.log2len - 1)) / this.log2len;
        this.numHashShifts = Math.min(12, this.numHashShifts);
        this.keys = new long[arrayLength];
        if (withValues) {
            this.values = new Object[arrayLength];
        }
    }

    class Entry
    extends AbstractMap.SimpleEntry<ObjId, V> {
        private final int modcount;
        private final int slot;

        Entry(int slot) {
            super(new ObjId(ObjIdMap.this.keys[slot]), ObjIdMap.this.values != null ? ObjIdMap.this.values[slot] : null);
            this.modcount = ObjIdMap.this.modcount;
            this.slot = slot;
        }

        @Override
        public V setValue(V value) {
            if (ObjIdMap.this.modcount != this.modcount) {
                throw new ConcurrentModificationException();
            }
            if (ObjIdMap.this.values != null) {
                ((ObjIdMap)ObjIdMap.this).values[this.slot] = value;
            }
            return super.setValue(value);
        }
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<ObjId, V>> {
        private int modcount;
        private int removeSlot;
        private int nextSlot;

        EntrySetIterator() {
            this.modcount = ObjIdMap.this.modcount;
            this.removeSlot = -1;
        }

        @Override
        public boolean hasNext() {
            return this.findNext(false) != -1;
        }

        @Override
        public Entry next() {
            int slot = this.findNext(true);
            if (slot == -1) {
                throw new NoSuchElementException();
            }
            long key = ObjIdMap.this.keys[slot];
            assert (key != 0L);
            this.removeSlot = slot;
            return new Entry(slot);
        }

        @Override
        public void remove() {
            if (this.removeSlot == -1) {
                throw new IllegalStateException();
            }
            if (this.modcount != ObjIdMap.this.modcount) {
                throw new ConcurrentModificationException();
            }
            ObjIdMap.this.exsert(this.removeSlot);
            this.removeSlot = -1;
            ++this.modcount;
        }

        private int findNext(boolean advance) {
            if (this.modcount != ObjIdMap.this.modcount) {
                throw new ConcurrentModificationException();
            }
            for (int slot = this.nextSlot; slot < ObjIdMap.this.keys.length; ++slot) {
                if (ObjIdMap.this.keys[slot] == 0L) continue;
                this.nextSlot = advance ? slot + 1 : slot;
                return slot;
            }
            return -1;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<ObjId, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<ObjId, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return ObjIdMap.this.size;
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            Object actualValue = ObjIdMap.this.get(key);
            if (actualValue == null && !ObjIdMap.this.containsKey(key)) {
                return false;
            }
            return entry.equals(new AbstractMap.SimpleEntry((ObjId)key, actualValue));
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            Object actualValue = ObjIdMap.this.get(key);
            if (actualValue == null && !ObjIdMap.this.containsKey(key)) {
                return false;
            }
            if (actualValue != null ? actualValue.equals(entry.getValue()) : entry.getValue() == null) {
                ObjIdMap.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ObjIdMap.this.clear();
        }

        @Override
        public int hashCode() {
            long[] keyArray = ObjIdMap.this.keys;
            Object[] valueArray = ObjIdMap.this.values;
            int hash = 0;
            for (int i = 0; i < keyArray.length; ++i) {
                Object value;
                long key = keyArray[i];
                if (key == 0L) continue;
                int entryHash = (int)(key >>> 32) ^ (int)key;
                if (valueArray != null && (value = valueArray[i]) != null) {
                    entryHash ^= value.hashCode();
                }
                hash += entryHash;
            }
            return hash;
        }
    }
}

