/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jsimpledb.schema.ComplexSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;
import org.jsimpledb.util.Diffs;

public abstract class CollectionSchemaField
extends ComplexSchemaField {
    private SimpleSchemaField elementField;

    public SimpleSchemaField getElementField() {
        return this.elementField;
    }

    public void setElementField(SimpleSchemaField elementField) {
        this.verifyNotLockedDown();
        this.elementField = elementField;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        if (this.elementField != null) {
            this.elementField.lockDown();
        }
    }

    @Override
    public Map<String, SimpleSchemaField> getSubFields() {
        return Collections.singletonMap("element", this.elementField);
    }

    @Override
    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        this.elementField = this.readSubField(reader, formatVersion, "element");
        this.expectClose(reader);
    }

    protected Diffs differencesFrom(CollectionSchemaField that) {
        Diffs diffs = new Diffs(super.differencesFrom(that));
        Diffs elementDiffs = this.elementField.differencesFrom(that.elementField);
        if (!elementDiffs.isEmpty()) {
            diffs.add("changed element field", elementDiffs);
        }
        return diffs;
    }

    @Override
    public String toString() {
        return super.toString() + (this.elementField != null ? " with element " + this.elementField : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CollectionSchemaField that = (CollectionSchemaField)obj;
        return Objects.equals(this.elementField, that.elementField);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.elementField);
    }

    @Override
    public CollectionSchemaField clone() {
        CollectionSchemaField clone = (CollectionSchemaField)super.clone();
        if (clone.elementField != null) {
            clone.elementField = clone.elementField.clone();
        }
        return clone;
    }
}

