/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SimpleSchemaField;

public abstract class ComplexSchemaField
extends SchemaField {
    public abstract Map<String, SimpleSchemaField> getSubFields();

    @Override
    void validate() {
        super.validate();
        for (Map.Entry<String, SimpleSchemaField> entry : this.getSubFields().entrySet()) {
            String subFieldName = entry.getKey();
            SimpleSchemaField subField = entry.getValue();
            if (subField == null) {
                throw new InvalidSchemaException("invalid " + this + ": missing sub-field `" + subFieldName + "'");
            }
            subField.validate();
            if (subFieldName.equals(subField.getName())) continue;
            throw new InvalidSchemaException("sub-" + subField + " of " + this + " has the wrong name `" + subField.getName() + "' != `" + subFieldName + "'");
        }
    }

    @Override
    boolean isCompatibleWith(SchemaField field) {
        if (field.getClass() != this.getClass()) {
            return false;
        }
        ComplexSchemaField that = (ComplexSchemaField)field;
        return AbstractSchemaItem.isAll(this.getSubFields(), that.getSubFields(), SimpleSchemaField::isCompatibleWith);
    }

    @Override
    void writeCompatibilityHashData(DataOutputStream output) throws IOException {
        super.writeCompatibilityHashData(output);
        for (Map.Entry<String, SimpleSchemaField> entry : this.getSubFields().entrySet()) {
            output.writeUTF(entry.getKey());
            entry.getValue().writeCompatibilityHashData(output);
        }
    }

    SimpleSchemaField readSubField(XMLStreamReader reader, int formatVersion, String name) throws XMLStreamException {
        SimpleSchemaField field = (SimpleSchemaField)this.readMappedType(reader, false, SchemaModel.SIMPLE_FIELD_TAG_MAP);
        field.readXML(reader, formatVersion);
        if (field.getName() == null) {
            field.setName(name);
        }
        return field;
    }

    @Override
    void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        QName tag = this.getXMLTag();
        writer.writeStartElement(tag.getNamespaceURI(), tag.getLocalPart());
        this.writeAttributes(writer);
        for (SimpleSchemaField subField : this.getSubFields().values()) {
            subField.writeXML(writer, false);
        }
        writer.writeEndElement();
    }

    abstract QName getXMLTag();

    @Override
    public ComplexSchemaField clone() {
        return (ComplexSchemaField)super.clone();
    }
}

