/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.schema;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.xml.IndentXMLStreamWriter;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.ComplexSchemaField;
import org.jsimpledb.schema.CounterSchemaField;
import org.jsimpledb.schema.EnumSchemaField;
import org.jsimpledb.schema.ListSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.schema.SchemaSupport;
import org.jsimpledb.schema.SetSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;
import org.jsimpledb.schema.XMLConstants;
import org.jsimpledb.util.DiffGenerating;
import org.jsimpledb.util.Diffs;
import org.jsimpledb.util.NavigableSets;

public class SchemaModel
extends SchemaSupport
implements DiffGenerating<SchemaModel> {
    static final Map<QName, Class<? extends SchemaField>> FIELD_TAG_MAP = new HashMap<QName, Class<? extends SchemaField>>();
    static final Map<QName, Class<? extends SimpleSchemaField>> SIMPLE_FIELD_TAG_MAP;
    static final Map<QName, Class<? extends AbstractSchemaItem>> FIELD_OR_COMPOSITE_INDEX_TAG_MAP;
    private static final String XML_OUTPUT_FACTORY_PROPERTY = "javax.xml.stream.XMLOutputFactory";
    private static final String DEFAULT_XML_OUTPUT_FACTORY_IMPLEMENTATION = "com.sun.xml.internal.stream.XMLOutputFactoryImpl";
    private static final int CURRENT_FORMAT_VERSION = 2;
    private static final int VALIDATION_RESULT_KEY = 1;
    private static final int COMPATIBILITY_HASH_KEY = 2;
    private NavigableMap<Integer, SchemaObjectType> schemaObjectTypes = new TreeMap<Integer, SchemaObjectType>();
    private final HashMap<Integer, Object> lockedDownCache = new HashMap();

    public NavigableMap<Integer, SchemaObjectType> getSchemaObjectTypes() {
        return this.schemaObjectTypes;
    }

    public void toXML(OutputStream output, boolean indent) throws IOException {
        try {
            XMLOutputFactory factory;
            boolean setDefault;
            boolean bl = setDefault = System.getProperty(XML_OUTPUT_FACTORY_PROPERTY) == null;
            if (setDefault) {
                System.setProperty(XML_OUTPUT_FACTORY_PROPERTY, DEFAULT_XML_OUTPUT_FACTORY_IMPLEMENTATION);
            }
            try {
                factory = XMLOutputFactory.newInstance();
            }
            catch (RuntimeException e) {
                if (!setDefault) {
                    throw e;
                }
                System.clearProperty(XML_OUTPUT_FACTORY_PROPERTY);
                factory = XMLOutputFactory.newInstance();
            }
            XMLStreamWriter writer = factory.createXMLStreamWriter(output, "UTF-8");
            if (indent) {
                writer = new IndentXMLStreamWriter(writer);
            }
            writer.writeStartDocument("UTF-8", "1.0");
            this.writeXML(writer);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException("internal error", e);
        }
        new PrintStream(output, true, "UTF-8").println();
        output.flush();
    }

    public static SchemaModel fromXML(InputStream input) throws IOException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        SchemaModel schemaModel = new SchemaModel();
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            schemaModel.readXML(reader);
        }
        catch (XMLStreamException e) {
            throw new InvalidSchemaException("error parsing schema model XML", e);
        }
        schemaModel.validate();
        return schemaModel;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        this.schemaObjectTypes = Collections.unmodifiableNavigableMap(this.schemaObjectTypes);
        for (SchemaObjectType schemaObjectType : this.schemaObjectTypes.values()) {
            schemaObjectType.lockDown();
        }
    }

    private <T> T calculate(Class<T> type, int key, Supplier<T> supplier) {
        if (!this.lockedDown) {
            return supplier.get();
        }
        T value = type.cast(this.lockedDownCache.get(key));
        if (value == null && !this.lockedDownCache.containsKey(key)) {
            value = supplier.get();
            this.lockedDownCache.put(key, value);
        }
        return value;
    }

    public void validate() {
        RuntimeException failure = this.calculate(RuntimeException.class, 1, () -> {
            try {
                this.doValidate();
            }
            catch (RuntimeException e) {
                return e;
            }
            return null;
        });
        if (failure != null) {
            throw failure;
        }
    }

    private void doValidate() {
        TreeMap<String, SchemaObjectType> schemaObjectTypesByName = new TreeMap<String, SchemaObjectType>();
        for (SchemaObjectType schemaObjectType : this.schemaObjectTypes.values()) {
            schemaObjectType.validate();
            String schemaObjectTypeName = schemaObjectType.getName();
            SchemaObjectType otherSchemaObjectType = schemaObjectTypesByName.put(schemaObjectTypeName, schemaObjectType);
            if (otherSchemaObjectType == null) continue;
            throw new InvalidSchemaException("duplicate object name `" + schemaObjectTypeName + "'");
        }
        TreeMap<Integer, SchemaField> globalItemsByStorageId = new TreeMap<Integer, SchemaField>();
        for (SchemaObjectType schemaObjectType : this.schemaObjectTypes.values()) {
            for (SchemaField field : schemaObjectType.getSchemaFields().values()) {
                globalItemsByStorageId.put(field.getStorageId(), field);
                if (!(field instanceof ComplexSchemaField)) continue;
                ComplexSchemaField complexField = (ComplexSchemaField)field;
                for (SimpleSchemaField subField : complexField.getSubFields().values()) {
                    globalItemsByStorageId.put(subField.getStorageId(), subField);
                }
            }
        }
        for (SchemaObjectType schemaObjectType : this.schemaObjectTypes.values()) {
            SchemaModel.verifyUniqueStorageId(globalItemsByStorageId, schemaObjectType);
            for (SchemaCompositeIndex index : schemaObjectType.getSchemaCompositeIndexes().values()) {
                SchemaModel.verifyUniqueStorageId(globalItemsByStorageId, index);
            }
        }
    }

    static <T extends AbstractSchemaItem> void verifyUniqueStorageId(TreeMap<Integer, T> itemsByStorageId, T item) {
        int storageId = item.getStorageId();
        AbstractSchemaItem previous = (AbstractSchemaItem)itemsByStorageId.get(storageId);
        if (previous != null && !previous.equals(item)) {
            throw new InvalidSchemaException("incompatible duplicate use of storage ID " + storageId + " by both " + previous + " and " + item);
        }
        itemsByStorageId.put(storageId, item);
    }

    public boolean isCompatibleWith(SchemaModel that) {
        Preconditions.checkArgument((that != null ? 1 : 0) != 0, (Object)"null that");
        if (this == that) {
            return true;
        }
        return AbstractSchemaItem.isAll(this.schemaObjectTypes, that.schemaObjectTypes, SchemaObjectType::isCompatibleWith);
    }

    public long compatibilityHash() {
        return this.calculate(Long.class, 2, this::computeCompatibilityHash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long computeCompatibilityHash() {
        Throwable throwable;
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        OutputStream discardOutputStream = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
            }
        };
        try {
            throwable = null;
            try (DigestOutputStream output = new DigestOutputStream(discardOutputStream, sha1);){
                this.writeCompatibilityHashData(output);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        try {
            throwable = null;
            try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(sha1.digest()));){
                long l = input.readLong();
                return l;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    private void writeCompatibilityHashData(OutputStream stream) throws IOException {
        try (DataOutputStream output = new DataOutputStream(stream);){
            output.writeInt(this.schemaObjectTypes.size());
            for (SchemaObjectType schemaObjectType : this.schemaObjectTypes.values()) {
                schemaObjectType.writeCompatibilityHashData(output);
            }
        }
    }

    public int autogenerateVersion() {
        int version = (int)(this.compatibilityHash() >>> 33);
        if (version == 0) {
            version = 1;
        }
        return version;
    }

    public Diffs differencesFrom(SchemaModel that) {
        Preconditions.checkArgument((that != null ? 1 : 0) != 0, (Object)"null that");
        Diffs diffs = new Diffs();
        NavigableSet allObjectTypeIds = NavigableSets.union((NavigableSet[])new NavigableSet[]{this.schemaObjectTypes.navigableKeySet(), that.schemaObjectTypes.navigableKeySet()});
        Iterator iterator = allObjectTypeIds.iterator();
        while (iterator.hasNext()) {
            int storageId = (Integer)iterator.next();
            SchemaObjectType thisObjectType = (SchemaObjectType)this.schemaObjectTypes.get(storageId);
            SchemaObjectType thatObjectType = (SchemaObjectType)that.schemaObjectTypes.get(storageId);
            if (thisObjectType == null) {
                diffs.add("removed " + thatObjectType);
                continue;
            }
            if (thatObjectType == null) {
                diffs.add("added " + thisObjectType);
                continue;
            }
            Diffs objectTypeDiffs = thisObjectType.differencesFrom(thatObjectType);
            if (objectTypeDiffs.isEmpty()) continue;
            diffs.add("changed " + thatObjectType, objectTypeDiffs);
        }
        return diffs;
    }

    void readXML(XMLStreamReader reader) throws XMLStreamException {
        QName objectTypeTag;
        this.schemaObjectTypes.clear();
        this.expect(reader, false, new QName[]{XMLConstants.SCHEMA_MODEL_TAG});
        Integer formatAttr = this.getIntAttr(reader, XMLConstants.FORMAT_VERSION_ATTRIBUTE, false);
        int formatVersion = formatAttr != null ? formatAttr : 0;
        switch (formatVersion) {
            case 0: {
                objectTypeTag = new QName("Object");
                break;
            }
            case 1: 
            case 2: {
                objectTypeTag = XMLConstants.OBJECT_TYPE_TAG;
                break;
            }
            default: {
                throw new XMLStreamException("unrecognized schema format version " + formatAttr, reader.getLocation());
            }
        }
        while (this.expect(reader, true, new QName[]{objectTypeTag})) {
            SchemaObjectType schemaObjectType = new SchemaObjectType();
            schemaObjectType.readXML(reader, formatVersion);
            int storageId = schemaObjectType.getStorageId();
            SchemaObjectType previous = this.schemaObjectTypes.put(storageId, schemaObjectType);
            if (previous == null) continue;
            throw new XMLStreamException("duplicate use of storage ID " + storageId + " for both " + previous + " and " + schemaObjectType, reader.getLocation());
        }
    }

    void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.setDefaultNamespace(XMLConstants.SCHEMA_MODEL_TAG.getNamespaceURI());
        writer.writeStartElement(XMLConstants.SCHEMA_MODEL_TAG.getNamespaceURI(), XMLConstants.SCHEMA_MODEL_TAG.getLocalPart());
        writer.writeAttribute(XMLConstants.FORMAT_VERSION_ATTRIBUTE.getNamespaceURI(), XMLConstants.FORMAT_VERSION_ATTRIBUTE.getLocalPart(), "2");
        ArrayList typeList = new ArrayList(this.schemaObjectTypes.values());
        Collections.sort(typeList, Comparator.comparing(AbstractSchemaItem::getName));
        for (SchemaObjectType schemaObjectType : typeList) {
            schemaObjectType.writeXML(writer);
        }
        writer.writeEndElement();
    }

    public String toString() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            this.toXML(buf, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(buf.toByteArray(), Charset.forName("UTF-8")).replaceAll("(?s)<\\?xml version=\"1\\.0\" encoding=\"UTF-8\"\\?>\n", "").trim();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SchemaModel that = (SchemaModel)obj;
        return this.schemaObjectTypes.equals(that.schemaObjectTypes);
    }

    public int hashCode() {
        return this.schemaObjectTypes.hashCode();
    }

    @Override
    public SchemaModel clone() {
        SchemaModel clone = (SchemaModel)super.clone();
        clone.schemaObjectTypes = new TreeMap<Integer, SchemaObjectType>((SortedMap<Integer, SchemaObjectType>)clone.schemaObjectTypes);
        for (Map.Entry entry : clone.schemaObjectTypes.entrySet()) {
            entry.setValue(((SchemaObjectType)entry.getValue()).clone());
        }
        return clone;
    }

    static {
        FIELD_TAG_MAP.put(XMLConstants.COUNTER_FIELD_TAG, CounterSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.ENUM_FIELD_TAG, EnumSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.LIST_FIELD_TAG, ListSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.MAP_FIELD_TAG, MapSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.REFERENCE_FIELD_TAG, ReferenceSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.SET_FIELD_TAG, SetSchemaField.class);
        FIELD_TAG_MAP.put(XMLConstants.SIMPLE_FIELD_TAG, SimpleSchemaField.class);
        SIMPLE_FIELD_TAG_MAP = new HashMap<QName, Class<? extends SimpleSchemaField>>();
        FIELD_TAG_MAP.entrySet().stream().filter(entry -> SimpleSchemaField.class.isAssignableFrom((Class)entry.getValue())).forEach(entry -> SIMPLE_FIELD_TAG_MAP.put((QName)entry.getKey(), (Class<? extends SimpleSchemaField>)((Class)entry.getValue()).asSubclass(SimpleSchemaField.class)));
        FIELD_OR_COMPOSITE_INDEX_TAG_MAP = new HashMap<QName, Class<? extends AbstractSchemaItem>>();
        FIELD_OR_COMPOSITE_INDEX_TAG_MAP.putAll(FIELD_TAG_MAP);
        FIELD_OR_COMPOSITE_INDEX_TAG_MAP.put(XMLConstants.COMPOSITE_INDEX_TAG, SchemaCompositeIndex.class);
    }
}

