/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.TableFormatConfig;

public class ColumnFamilyOptions
extends RocksObject
implements ColumnFamilyOptionsInterface {
    MemTableConfig memTableConfig_;
    TableFormatConfig tableFormatConfig_;
    AbstractComparator<? extends AbstractSlice<?>> comparator_;
    AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter_;

    public ColumnFamilyOptions() {
        super(ColumnFamilyOptions.newColumnFamilyOptions());
    }

    public static ColumnFamilyOptions getColumnFamilyOptionsFromProps(Properties properties) {
        if (properties == null || properties.size() == 0) {
            throw new IllegalArgumentException("Properties value must contain at least one value.");
        }
        ColumnFamilyOptions columnFamilyOptions = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : properties.stringPropertyNames()) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(properties.getProperty(string));
            stringBuilder.append(";");
        }
        long l = ColumnFamilyOptions.getColumnFamilyOptionsFromProps(stringBuilder.toString());
        if (l != 0L) {
            columnFamilyOptions = new ColumnFamilyOptions(l);
        }
        return columnFamilyOptions;
    }

    @Override
    public ColumnFamilyOptions optimizeForPointLookup(long l) {
        this.optimizeForPointLookup(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction(long l) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction(long l) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(BuiltinComparator builtinComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(AbstractComparator<? extends AbstractSlice<?>> abstractComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, abstractComparator.getNativeHandle());
        this.comparator_ = abstractComparator;
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperatorName(String string) {
        assert (this.isOwningHandle());
        if (string == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, string);
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.newMergeOperatorHandle());
        return this;
    }

    public ColumnFamilyOptions setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> abstractCompactionFilter) {
        this.setCompactionFilterHandle(this.nativeHandle_, abstractCompactionFilter.nativeHandle_);
        this.compactionFilter_ = abstractCompactionFilter;
        return this;
    }

    @Override
    public ColumnFamilyOptions setWriteBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isOwningHandle());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxWriteBufferNumber(int n) {
        assert (this.isOwningHandle());
        this.setMaxWriteBufferNumber(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isOwningHandle());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMinWriteBufferNumberToMerge(int n) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions useFixedLengthPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions useCappedPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useCappedPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.values()[this.compressionType(this.nativeHandle_)];
    }

    @Override
    public ColumnFamilyOptions setCompressionPerLevel(List<CompressionType> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i).getValue();
        }
        this.setCompressionPerLevel(this.nativeHandle_, byArray);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        byte[] byArray = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> arrayList = new ArrayList<CompressionType>();
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            Byte by = byArray2[i];
            arrayList.add(CompressionType.getCompressionType(by));
        }
        return arrayList;
    }

    @Override
    public ColumnFamilyOptions setNumLevels(int n) {
        this.setNumLevels(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroFileNumCompactionTrigger(int n) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroSlowdownWritesTrigger(int n) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroStopWritesTrigger(int n) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxMemCompactionLevel(int n) {
        return this;
    }

    @Override
    public int maxMemCompactionLevel() {
        return 0;
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeBase(long l) {
        this.setTargetFileSizeBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeMultiplier(int n) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelBase(long l) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelCompactionDynamicLevelBytes(boolean bl) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelMultiplier(int n) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setExpandedCompactionFactor(int n) {
        this.setExpandedCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int expandedCompactionFactor() {
        return this.expandedCompactionFactor(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setSourceCompactionFactor(int n) {
        this.setSourceCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int sourceCompactionFactor() {
        return this.sourceCompactionFactor(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxGrandparentOverlapFactor(int n) {
        this.setMaxGrandparentOverlapFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxGrandparentOverlapFactor() {
        return this.maxGrandparentOverlapFactor(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setSoftRateLimit(double d) {
        this.setSoftRateLimit(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double softRateLimit() {
        return this.softRateLimit(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setHardRateLimit(double d) {
        this.setHardRateLimit(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double hardRateLimit() {
        return this.hardRateLimit(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setRateLimitDelayMaxMilliseconds(int n) {
        this.setRateLimitDelayMaxMilliseconds(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int rateLimitDelayMaxMilliseconds() {
        return this.rateLimitDelayMaxMilliseconds(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setArenaBlockSize(long l) {
        this.setArenaBlockSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setDisableAutoCompactions(boolean bl) {
        this.setDisableAutoCompactions(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setPurgeRedundantKvsWhileFlush(boolean bl) {
        this.setPurgeRedundantKvsWhileFlush(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean purgeRedundantKvsWhileFlush() {
        return this.purgeRedundantKvsWhileFlush(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.values()[this.compactionStyle(this.nativeHandle_)];
    }

    @Override
    public ColumnFamilyOptions setMaxTableFilesSizeFIFO(long l) {
        assert (l > 0L);
        assert (this.isOwningHandle());
        this.setMaxTableFilesSizeFIFO(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.maxTableFilesSizeFIFO(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setVerifyChecksumsInCompaction(boolean bl) {
        this.setVerifyChecksumsInCompaction(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean verifyChecksumsInCompaction() {
        return this.verifyChecksumsInCompaction(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSequentialSkipInIterations(long l) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemTableConfig(MemTableConfig memTableConfig) {
        this.memTableConfig_ = memTableConfig;
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        return this;
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isOwningHandle());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.tableFormatConfig_ = tableFormatConfig;
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isOwningHandle());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateSupport(boolean bl) {
        this.setInplaceUpdateSupport(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateNumLocks(long l) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemtablePrefixBloomSizeRatio(double d) {
        this.setMemtablePrefixBloomSizeRatio(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.memtablePrefixBloomSizeRatio(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBloomLocality(int n) {
        this.setBloomLocality(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSuccessiveMerges(long l) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMinPartialMergeOperands(int n) {
        this.setMinPartialMergeOperands(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int minPartialMergeOperands() {
        return this.minPartialMergeOperands(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setOptimizeFiltersForHits(boolean bl) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    private ColumnFamilyOptions(long l) {
        super(l);
    }

    private static native long getColumnFamilyOptionsFromProps(String var0);

    private static native long newColumnFamilyOptions();

    @Override
    protected final native void disposeInternal(long var1);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setCompactionFilterHandle(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, byte[] var3);

    private native byte[] compressionPerLevel(long var1);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void useCappedPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, int var3);

    private native int maxBytesForLevelMultiplier(long var1);

    private native void setExpandedCompactionFactor(long var1, int var3);

    private native int expandedCompactionFactor(long var1);

    private native void setSourceCompactionFactor(long var1, int var3);

    private native int sourceCompactionFactor(long var1);

    private native void setMaxGrandparentOverlapFactor(long var1, int var3);

    private native int maxGrandparentOverlapFactor(long var1);

    private native void setSoftRateLimit(long var1, double var3);

    private native double softRateLimit(long var1);

    private native void setHardRateLimit(long var1, double var3);

    private native double hardRateLimit(long var1);

    private native void setRateLimitDelayMaxMilliseconds(long var1, int var3);

    private native int rateLimitDelayMaxMilliseconds(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setMaxTableFilesSizeFIFO(long var1, long var3);

    private native long maxTableFilesSizeFIFO(long var1);

    private native void setPurgeRedundantKvsWhileFlush(long var1, boolean var3);

    private native boolean purgeRedundantKvsWhileFlush(long var1);

    private native void setVerifyChecksumsInCompaction(long var1, boolean var3);

    private native boolean verifyChecksumsInCompaction(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomSizeRatio(long var1, double var3);

    private native double memtablePrefixBloomSizeRatio(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setMinPartialMergeOperands(long var1, int var3);

    private native int minPartialMergeOperands(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

