/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractSlice;

public class DirectSlice
extends AbstractSlice<ByteBuffer> {
    public static final DirectSlice NONE = new DirectSlice();

    DirectSlice() {
    }

    public DirectSlice(String string) {
        super(DirectSlice.createNewSliceFromString(string));
    }

    public DirectSlice(ByteBuffer byteBuffer, int n) {
        super(DirectSlice.createNewDirectSlice0(DirectSlice.ensureDirect(byteBuffer), n));
    }

    public DirectSlice(ByteBuffer byteBuffer) {
        super(DirectSlice.createNewDirectSlice1(DirectSlice.ensureDirect(byteBuffer)));
    }

    private static ByteBuffer ensureDirect(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        return byteBuffer;
    }

    public byte get(int n) {
        return this.get0(this.getNativeHandle(), n);
    }

    public void clear() {
        this.clear0(this.getNativeHandle());
    }

    public void removePrefix(int n) {
        this.removePrefix0(this.getNativeHandle(), n);
    }

    private static native long createNewDirectSlice0(ByteBuffer var0, int var1);

    private static native long createNewDirectSlice1(ByteBuffer var0);

    @Override
    protected final native ByteBuffer data0(long var1);

    private native byte get0(long var1, int var3);

    private native void clear0(long var1);

    private native void removePrefix0(long var1, int var3);
}

