/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class NameResolverProvider
extends NameResolver.Factory {
    public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = NameResolver.Factory.PARAMS_DEFAULT_PORT;
    private static final List<NameResolverProvider> providers = NameResolverProvider.load(NameResolverProvider.getCorrectClassLoader());
    private static final NameResolver.Factory factory = new NameResolverFactory(providers);

    @VisibleForTesting
    static List<NameResolverProvider> load(ClassLoader classLoader) {
        Iterable<NameResolverProvider> candidates = NameResolverProvider.isAndroid() ? NameResolverProvider.getCandidatesViaHardCoded(classLoader) : NameResolverProvider.getCandidatesViaServiceLoader(classLoader);
        ArrayList<NameResolverProvider> list = new ArrayList<NameResolverProvider>();
        for (NameResolverProvider current : candidates) {
            if (!current.isAvailable()) continue;
            list.add(current);
        }
        Collections.sort(list, Collections.reverseOrder(new Comparator<NameResolverProvider>(){

            @Override
            public int compare(NameResolverProvider f1, NameResolverProvider f2) {
                return f1.priority() - f2.priority();
            }
        }));
        return Collections.unmodifiableList(list);
    }

    @VisibleForTesting
    public static Iterable<NameResolverProvider> getCandidatesViaServiceLoader(ClassLoader classLoader) {
        return ServiceLoader.load(NameResolverProvider.class, classLoader);
    }

    @VisibleForTesting
    public static Iterable<NameResolverProvider> getCandidatesViaHardCoded(ClassLoader classLoader) {
        ArrayList<NameResolverProvider> list = new ArrayList<NameResolverProvider>();
        try {
            list.add(NameResolverProvider.create(Class.forName("io.grpc.internal.DnsNameResolverProvider", true, classLoader)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    @VisibleForTesting
    static NameResolverProvider create(Class<?> rawClass) {
        try {
            return rawClass.asSubclass(NameResolverProvider.class).newInstance();
        }
        catch (Throwable t) {
            throw new ServiceConfigurationError("Provider " + rawClass.getName() + " could not be instantiated: " + t, t);
        }
    }

    public static List<NameResolverProvider> providers() {
        return providers;
    }

    public static NameResolver.Factory asFactory() {
        return factory;
    }

    @VisibleForTesting
    static NameResolver.Factory asFactory(List<NameResolverProvider> providers) {
        return new NameResolverFactory(providers);
    }

    private static ClassLoader getCorrectClassLoader() {
        if (NameResolverProvider.isAndroid()) {
            return NameResolverProvider.class.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    private static class NameResolverFactory
    extends NameResolver.Factory {
        private final List<NameResolverProvider> providers;

        public NameResolverFactory(List<NameResolverProvider> providers) {
            this.providers = providers;
        }

        @Override
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            this.checkForProviders();
            for (NameResolverProvider provider : this.providers) {
                NameResolver resolver = provider.newNameResolver(targetUri, params);
                if (resolver == null) continue;
                return resolver;
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            this.checkForProviders();
            return this.providers.get(0).getDefaultScheme();
        }

        private void checkForProviders() {
            Preconditions.checkState((!this.providers.isEmpty() ? 1 : 0) != 0, (Object)"No NameResolverProviders found via ServiceLoader, including for DNS. This is probably due to a broken build. If using ProGuard, check your configuration");
        }
    }
}

