/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ManagedClientTransport;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class KeepAliveManager {
    private static final SystemTicker SYSTEM_TICKER = new SystemTicker();
    private static final long MIN_KEEPALIVE_DELAY_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private final ScheduledExecutorService scheduler;
    private final ManagedClientTransport transport;
    private final Ticker ticker;
    private State state = State.IDLE;
    private long nextKeepaliveTime;
    private ScheduledFuture<?> shutdownFuture;
    private ScheduledFuture<?> pingFuture;
    private final Runnable shutdown = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shouldShutdown = false;
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                if (KeepAliveManager.this.state != State.DISCONNECTED) {
                    KeepAliveManager.this.state = State.DISCONNECTED;
                    shouldShutdown = true;
                }
            }
            if (shouldShutdown) {
                KeepAliveManager.this.transport.shutdownNow(Status.UNAVAILABLE.withDescription("Keepalive failed. The connection is likely gone"));
            }
        }
    };
    private final Runnable sendPing = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shouldSendPing = false;
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                if (KeepAliveManager.this.state == State.PING_SCHEDULED) {
                    shouldSendPing = true;
                    KeepAliveManager.this.state = State.PING_SENT;
                    KeepAliveManager.this.shutdownFuture = KeepAliveManager.this.scheduler.schedule(KeepAliveManager.this.shutdown, KeepAliveManager.this.keepAliveTimeoutInNanos, TimeUnit.NANOSECONDS);
                } else if (KeepAliveManager.this.state == State.PING_DELAYED) {
                    KeepAliveManager.this.pingFuture = KeepAliveManager.this.scheduler.schedule(KeepAliveManager.this.sendPing, KeepAliveManager.this.nextKeepaliveTime - KeepAliveManager.this.ticker.read(), TimeUnit.NANOSECONDS);
                    KeepAliveManager.this.state = State.PING_SCHEDULED;
                }
            }
            if (shouldSendPing) {
                KeepAliveManager.this.transport.ping(KeepAliveManager.this.pingCallback, MoreExecutors.directExecutor());
            }
        }
    };
    private final KeepAlivePingCallback pingCallback = new KeepAlivePingCallback();
    private long keepAliveDelayInNanos;
    private long keepAliveTimeoutInNanos;

    public KeepAliveManager(ManagedClientTransport transport, ScheduledExecutorService scheduler, long keepAliveDelayInNanos, long keepAliveTimeoutInNanos) {
        this.transport = (ManagedClientTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.ticker = SYSTEM_TICKER;
        this.keepAliveDelayInNanos = Math.max(MIN_KEEPALIVE_DELAY_NANOS, keepAliveDelayInNanos);
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.nextKeepaliveTime = this.ticker.read() + keepAliveDelayInNanos;
    }

    @VisibleForTesting
    KeepAliveManager(ManagedClientTransport transport, ScheduledExecutorService scheduler, Ticker ticker, long keepAliveDelayInNanos, long keepAliveTimeoutInNanos) {
        this.transport = (ManagedClientTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        this.keepAliveDelayInNanos = keepAliveDelayInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.nextKeepaliveTime = ticker.read() + keepAliveDelayInNanos;
    }

    public synchronized void onDataReceived() {
        this.nextKeepaliveTime = this.ticker.read() + this.keepAliveDelayInNanos;
        if (this.state == State.PING_SCHEDULED) {
            this.state = State.PING_DELAYED;
        }
    }

    public synchronized void onTransportActive() {
        if (this.state == State.IDLE) {
            this.state = State.PING_SCHEDULED;
            this.pingFuture = this.scheduler.schedule(this.sendPing, this.nextKeepaliveTime - this.ticker.read(), TimeUnit.NANOSECONDS);
        }
    }

    public synchronized void onTransportIdle() {
        if (this.state == State.PING_SCHEDULED || this.state == State.PING_DELAYED) {
            this.state = State.IDLE;
        }
        if (this.state == State.PING_SENT) {
            this.state = State.IDLE_AND_PING_SENT;
        }
    }

    public synchronized void onTransportShutdown() {
        if (this.state != State.DISCONNECTED) {
            this.state = State.DISCONNECTED;
            if (this.shutdownFuture != null) {
                this.shutdownFuture.cancel(false);
            }
            if (this.pingFuture != null) {
                this.pingFuture.cancel(false);
            }
        }
    }

    private static class SystemTicker
    extends Ticker {
        private SystemTicker() {
        }

        @Override
        public long read() {
            return System.nanoTime();
        }
    }

    static abstract class Ticker {
        Ticker() {
        }

        public abstract long read();
    }

    private class KeepAlivePingCallback
    implements ClientTransport.PingCallback {
        private KeepAlivePingCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(long roundTripTimeNanos) {
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                KeepAliveManager.this.shutdownFuture.cancel(false);
                KeepAliveManager.this.nextKeepaliveTime = KeepAliveManager.this.ticker.read() + KeepAliveManager.this.keepAliveDelayInNanos;
                if (KeepAliveManager.this.state == State.PING_SENT) {
                    KeepAliveManager.this.pingFuture = KeepAliveManager.this.scheduler.schedule(KeepAliveManager.this.sendPing, KeepAliveManager.this.keepAliveDelayInNanos, TimeUnit.NANOSECONDS);
                    KeepAliveManager.this.state = State.PING_SCHEDULED;
                }
                if (KeepAliveManager.this.state == State.IDLE_AND_PING_SENT) {
                    KeepAliveManager.this.state = State.IDLE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable cause) {
            KeepAliveManager keepAliveManager = KeepAliveManager.this;
            synchronized (keepAliveManager) {
                KeepAliveManager.this.shutdownFuture.cancel(false);
            }
            KeepAliveManager.this.shutdown.run();
        }
    }

    private static enum State {
        IDLE,
        PING_SCHEDULED,
        PING_DELAYED,
        PING_SENT,
        IDLE_AND_PING_SENT,
        DISCONNECTED;

    }
}

