/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.OptionConsumer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

abstract class OptionsSet {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    OptionConsumer consumer;

    public OptionsSet(OptionConsumer optionConsumer) {
        this.consumer = optionConsumer;
    }

    public OptionConsumer getOptionConsumer() {
        return this.consumer;
    }

    protected void setOption(int n) {
        this.consumer.setOption(n, null);
    }

    protected void setOption(int n, byte[] byArray) {
        this.consumer.setOption(n, byArray);
    }

    protected void setOption(int n, String string) {
        this.consumer.setOption(n, string.getBytes(CHARSET_UTF8));
    }

    protected void setOption(int n, long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(l);
        this.consumer.setOption(n, byteBuffer.array());
    }
}

