/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.sql;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLKVTransaction
extends ForwardingKVStore
implements KVTransaction {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final SQLKVDatabase database;
    protected final Connection connection;
    private long timeout;
    private boolean readOnly;
    private KVStore view;
    private volatile boolean mutated;
    private boolean closed;
    private boolean stale;

    public SQLKVTransaction(SQLKVDatabase database, Connection connection) throws SQLException {
        Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"null database");
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"null connection");
        this.database = database;
        this.connection = connection;
    }

    public SQLKVDatabase getKVDatabase() {
        return this.database;
    }

    public void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        this.timeout = timeout;
    }

    public Future<Void> watchKey(byte[] key) {
        throw new UnsupportedOperationException();
    }

    private synchronized byte[] getSQL(byte[] key) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        return this.queryBytes(StmtType.GET, new byte[][]{this.encodeKey(key)});
    }

    private synchronized KVPair getAtLeastSQL(byte[] minKey, byte[] maxKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        return minKey != null && minKey.length > 0 ? (maxKey != null ? this.queryKVPair(StmtType.GET_RANGE_FORWARD_SINGLE, this.encodeKey(minKey), this.encodeKey(maxKey)) : this.queryKVPair(StmtType.GET_AT_LEAST_FORWARD_SINGLE, new byte[][]{this.encodeKey(minKey)})) : (maxKey != null ? this.queryKVPair(StmtType.GET_AT_MOST_FORWARD_SINGLE, new byte[][]{this.encodeKey(maxKey)}) : this.queryKVPair(StmtType.GET_FIRST, new byte[0][]));
    }

    private synchronized KVPair getAtMostSQL(byte[] maxKey, byte[] minKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        return maxKey != null ? (minKey != null && minKey.length > 0 ? this.queryKVPair(StmtType.GET_RANGE_REVERSE_SINGLE, this.encodeKey(minKey), this.encodeKey(maxKey)) : this.queryKVPair(StmtType.GET_AT_MOST_REVERSE_SINGLE, new byte[][]{this.encodeKey(maxKey)})) : (minKey != null && minKey.length > 0 ? this.queryKVPair(StmtType.GET_AT_LEAST_REVERSE_SINGLE, new byte[][]{this.encodeKey(minKey)}) : this.queryKVPair(StmtType.GET_LAST, new byte[0][]));
    }

    private synchronized CloseableIterator<KVPair> getRangeSQL(byte[] minKey, byte[] maxKey, boolean reverse) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (minKey != null && minKey.length == 0) {
            minKey = null;
        }
        if (minKey == null && maxKey == null) {
            return this.queryIterator(reverse ? StmtType.GET_ALL_REVERSE : StmtType.GET_ALL_FORWARD, new byte[0][]);
        }
        if (minKey == null) {
            return this.queryIterator(reverse ? StmtType.GET_AT_MOST_REVERSE : StmtType.GET_AT_MOST_FORWARD, new byte[][]{this.encodeKey(maxKey)});
        }
        if (maxKey == null) {
            return this.queryIterator(reverse ? StmtType.GET_AT_LEAST_REVERSE : StmtType.GET_AT_LEAST_FORWARD, new byte[][]{this.encodeKey(minKey)});
        }
        return this.queryIterator(reverse ? StmtType.GET_RANGE_REVERSE : StmtType.GET_RANGE_FORWARD, this.encodeKey(minKey), this.encodeKey(maxKey));
    }

    private synchronized void putSQL(byte[] key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.update(StmtType.PUT, this.encodeKey(key), value, value);
    }

    private synchronized void removeSQL(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.update(StmtType.REMOVE, new byte[][]{this.encodeKey(key)});
    }

    private synchronized void removeRangeSQL(byte[] minKey, byte[] maxKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (minKey != null && minKey.length == 0) {
            minKey = null;
        }
        if (minKey == null && maxKey == null) {
            this.update(StmtType.REMOVE_ALL, new byte[0][]);
        } else if (minKey == null) {
            this.update(StmtType.REMOVE_AT_MOST, new byte[][]{this.encodeKey(maxKey)});
        } else if (maxKey == null) {
            this.update(StmtType.REMOVE_AT_LEAST, new byte[][]{this.encodeKey(minKey)});
        } else {
            this.update(StmtType.REMOVE_RANGE, this.encodeKey(minKey), this.encodeKey(maxKey));
        }
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void commit() {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.stale = true;
        try {
            if (this.readOnly && !(this.view instanceof MutableView)) {
                this.connection.rollback();
            } else {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw this.handleException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    public synchronized void rollback() {
        if (this.stale) {
            return;
        }
        this.stale = true;
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw this.handleException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    public CloseableKVStore mutableSnapshot() {
        throw new UnsupportedOperationException();
    }

    protected KVTransactionException handleException(SQLException e) {
        this.stale = true;
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.closeConnection();
        }
        return this.database.wrapException(this, e);
    }

    protected void closeConnection() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.stale) {
                this.log.warn((Object)((Object)this) + " leaked without commit() or rollback()");
            }
            this.closeConnection();
        }
        finally {
            super.finalize();
        }
    }

    public void put(byte[] key, byte[] value) {
        this.mutated = true;
        this.delegate().put(key, value);
    }

    public void remove(byte[] key) {
        this.mutated = true;
        this.delegate().remove(key);
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        this.mutated = true;
        this.delegate().removeRange(minKey, maxKey);
    }

    protected synchronized KVStore delegate() {
        if (this.view == null) {
            this.view = new SQLView();
        }
        return this.view;
    }

    public synchronized void setReadOnly(boolean readOnly) {
        if (readOnly == this.readOnly) {
            return;
        }
        Preconditions.checkArgument((boolean)readOnly, (Object)"read-only transaction cannot be made writable again");
        Preconditions.checkState((!this.mutated || this.database.rollbackForReadOnly ? 1 : 0) != 0, (Object)"data is already mutated");
        if (!this.database.rollbackForReadOnly) {
            this.view = new MutableView(this.view);
        }
        this.readOnly = readOnly;
    }

    protected byte[] queryBytes(StmtType stmtType, byte[] ... params) {
        return this.query(stmtType, (stmt, rs) -> rs.next() ? rs.getBytes(1) : null, true, params);
    }

    protected KVPair queryKVPair(StmtType stmtType, byte[] ... params) {
        return this.query(stmtType, (stmt, rs) -> rs.next() ? new KVPair(this.decodeKey(rs.getBytes(1)), rs.getBytes(2)) : null, true, params);
    }

    protected CloseableIterator<KVPair> queryIterator(StmtType stmtType, byte[] ... params) {
        return this.query(stmtType, (x$0, x$1) -> new ResultSetIterator(x$0, x$1), false, params);
    }

    protected <T> T query(StmtType stmtType, ResultSetFunction<T> resultSetFunction, boolean close, byte[] ... params) {
        try {
            PreparedStatement preparedStatement = stmtType.create(this.database, this.connection, this.log);
            int numParams = preparedStatement.getParameterMetaData().getParameterCount();
            for (int i = 0; i < params.length && i < numParams; ++i) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setting ?" + (i + 1) + " = " + ByteUtil.toString((byte[])params[i]));
                }
                preparedStatement.setBytes(i + 1, params[i]);
            }
            preparedStatement.setQueryTimeout((int)((this.timeout + 999L) / 1000L));
            if (this.log.isTraceEnabled()) {
                this.log.trace("executing SQL query: " + preparedStatement + " in " + (Object)((Object)this));
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            T result = resultSetFunction.apply(preparedStatement, resultSet);
            if (close) {
                resultSet.close();
                preparedStatement.close();
            }
            return result;
        }
        catch (SQLException e) {
            throw this.handleException(e);
        }
    }

    protected void update(StmtType stmtType, byte[] ... params) {
        try (PreparedStatement preparedStatement = stmtType.create(this.database, this.connection, this.log);){
            int numParams = preparedStatement.getParameterMetaData().getParameterCount();
            for (int i = 0; i < params.length && i < numParams; ++i) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setting ?" + (i + 1) + " = " + ByteUtil.toString((byte[])params[i]));
                }
                preparedStatement.setBytes(i + 1, params[i]);
            }
            preparedStatement.setQueryTimeout((int)((this.timeout + 999L) / 1000L));
            if (this.log.isTraceEnabled()) {
                this.log.trace("executing SQL update: " + preparedStatement + " in " + (Object)((Object)this));
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.handleException(e);
        }
    }

    protected byte[] encodeKey(byte[] key) {
        return key;
    }

    protected byte[] decodeKey(byte[] dbkey) {
        return dbkey;
    }

    protected static enum StmtType {
        GET{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetStatement(), log);
            }
        }
        ,
        GET_FIRST{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAllStatement(false)), log);
            }
        }
        ,
        GET_LAST{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAllStatement(true)), log);
            }
        }
        ,
        GET_AT_LEAST_FORWARD{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAtLeastStatement(false), log);
            }
        }
        ,
        GET_AT_LEAST_FORWARD_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAtLeastStatement(false)), log);
            }
        }
        ,
        GET_AT_LEAST_REVERSE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAtLeastStatement(true), log);
            }
        }
        ,
        GET_AT_LEAST_REVERSE_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAtLeastStatement(true)), log);
            }
        }
        ,
        GET_AT_MOST_FORWARD{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAtMostStatement(false), log);
            }
        }
        ,
        GET_AT_MOST_FORWARD_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAtMostStatement(false)), log);
            }
        }
        ,
        GET_AT_MOST_REVERSE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAtMostStatement(true), log);
            }
        }
        ,
        GET_AT_MOST_REVERSE_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetAtMostStatement(true)), log);
            }
        }
        ,
        GET_RANGE_FORWARD{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetRangeStatement(false), log);
            }
        }
        ,
        GET_RANGE_FORWARD_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetRangeStatement(false)), log);
            }
        }
        ,
        GET_RANGE_REVERSE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetRangeStatement(true), log);
            }
        }
        ,
        GET_RANGE_REVERSE_SINGLE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.limitSingleRow(db.createGetRangeStatement(true)), log);
            }
        }
        ,
        GET_ALL_FORWARD{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAllStatement(false), log);
            }
        }
        ,
        GET_ALL_REVERSE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createGetAllStatement(true), log);
            }
        }
        ,
        PUT{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createPutStatement(), log);
            }
        }
        ,
        REMOVE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createRemoveStatement(), log);
            }
        }
        ,
        REMOVE_RANGE{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createRemoveRangeStatement(), log);
            }
        }
        ,
        REMOVE_AT_LEAST{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createRemoveAtLeastStatement(), log);
            }
        }
        ,
        REMOVE_AT_MOST{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createRemoveAtMostStatement(), log);
            }
        }
        ,
        REMOVE_ALL{

            @Override
            protected PreparedStatement create(SQLKVDatabase db, Connection c, Logger log) throws SQLException {
                return this.prepare(c, db.createRemoveAllStatement(), log);
            }
        };


        protected abstract PreparedStatement create(SQLKVDatabase var1, Connection var2, Logger var3) throws SQLException;

        protected PreparedStatement prepare(Connection c, String sql, Logger log) throws SQLException {
            if (log.isTraceEnabled()) {
                log.trace("preparing SQL statement: " + sql);
            }
            return c.prepareStatement(sql);
        }
    }

    private class ResultSetIterator
    implements CloseableIterator<KVPair> {
        private final PreparedStatement preparedStatement;
        private final ResultSet resultSet;
        private boolean ready;
        private boolean closed;
        private byte[] removeKey;

        ResultSetIterator(PreparedStatement preparedStatement, ResultSet resultSet) {
            assert (preparedStatement != null);
            assert (resultSet != null);
            this.resultSet = resultSet;
            this.preparedStatement = preparedStatement;
        }

        public synchronized boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (this.ready) {
                return true;
            }
            try {
                this.ready = this.resultSet.next();
            }
            catch (SQLException e) {
                throw SQLKVTransaction.this.handleException(e);
            }
            if (!this.ready) {
                this.close();
            }
            return this.ready;
        }

        public synchronized KVPair next() {
            byte[] value;
            byte[] key;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                key = SQLKVTransaction.this.decodeKey(this.resultSet.getBytes(1));
                value = this.resultSet.getBytes(2);
            }
            catch (SQLException e) {
                throw SQLKVTransaction.this.handleException(e);
            }
            this.removeKey = (byte[])key.clone();
            this.ready = false;
            return new KVPair(key, value);
        }

        public synchronized void remove() {
            if (this.closed || this.removeKey == null) {
                throw new IllegalStateException();
            }
            SQLKVTransaction.this.remove(this.removeKey);
            this.removeKey = null;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static interface ResultSetFunction<T> {
        public T apply(PreparedStatement var1, ResultSet var2) throws SQLException;
    }

    private class SQLView
    extends AbstractKVStore {
        private SQLView() {
        }

        public byte[] get(byte[] key) {
            return SQLKVTransaction.this.getSQL(key);
        }

        public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
            return SQLKVTransaction.this.getAtLeastSQL(minKey, maxKey);
        }

        public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
            return SQLKVTransaction.this.getAtMostSQL(maxKey, minKey);
        }

        public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
            return SQLKVTransaction.this.getRangeSQL(minKey, maxKey, reverse);
        }

        public void put(byte[] key, byte[] value) {
            SQLKVTransaction.this.putSQL(key, value);
        }

        public void remove(byte[] key) {
            SQLKVTransaction.this.removeSQL(key);
        }

        public void removeRange(byte[] minKey, byte[] maxKey) {
            SQLKVTransaction.this.removeRangeSQL(minKey, maxKey);
        }
    }
}

