/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Session;
import org.jsimpledb.cli.Console;
import org.jsimpledb.cli.cmd.Command;
import org.jsimpledb.core.Database;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.util.ImplementationsReader;

public class CliSession
extends ParseSession {
    public static final String CLI_COMMANDS_DESCRIPTOR_RESOURCE = "META-INF/jsimpledb/cli-command-implementations.xml";
    private final Console console;
    private final PrintWriter writer;
    private final TreeMap<String, Command> commands = new TreeMap();
    private boolean done;
    private boolean verbose;
    private int lineLimit = 16;
    private String errorMessagePrefix = "Error: ";

    public CliSession(KVDatabase kvdb, PrintWriter writer, Console console) {
        super(kvdb);
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        this.writer = writer;
        this.console = console;
    }

    public CliSession(Database db, PrintWriter writer, Console console) {
        super(db);
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        this.writer = writer;
        this.console = console;
    }

    public CliSession(JSimpleDB jdb, PrintWriter writer, Console console) {
        super(jdb);
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        this.writer = writer;
        this.console = console;
    }

    public Console getConsole() {
        return this.console;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public SortedMap<String, Command> getCommands() {
        return this.commands;
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public void setLineLimit(int lineLimit) {
        this.lineLimit = lineLimit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void loadCommandsFromClasspath() {
        ImplementationsReader reader = new ImplementationsReader("cli-command");
        ArrayList<Object[]> paramLists = new ArrayList<Object[]>(2);
        paramLists.add(new Object[]{this});
        paramLists.add(new Object[0]);
        reader.setConstructorParameterLists(paramLists);
        reader.findImplementations(Command.class, CLI_COMMANDS_DESCRIPTOR_RESOURCE).forEach(this::registerCommand);
    }

    public void registerCommand(Command command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"null command");
        this.commands.put(command.getName(), command);
    }

    protected void reportException(Exception e) {
        String message = e.getLocalizedMessage();
        if (e instanceof ParseException && message != null) {
            this.writer.println(this.getErrorMessagePrefix() + message);
        } else {
            this.writer.println(this.getErrorMessagePrefix() + e.getClass().getSimpleName() + (message != null ? ": " + message : ""));
        }
        if (this.verbose || this.showStackTrace(e)) {
            e.printStackTrace(this.writer);
        }
    }

    protected boolean showStackTrace(Exception e) {
        return e instanceof NullPointerException || e instanceof ParseException && e.getLocalizedMessage() == null;
    }

    public String getErrorMessagePrefix() {
        return this.errorMessagePrefix;
    }

    public void setErrorMessagePrefix(String prefix) {
        this.errorMessagePrefix = prefix;
    }

    public boolean performCliSessionAction(Action action) {
        return this.performSessionAction(this.wrap(action));
    }

    public boolean performCliSessionActionWithCurrentTransaction(Action action) {
        return this.performSessionActionWithCurrentTransaction(this.wrap(action));
    }

    private WrapperAction wrap(Action action) {
        return action instanceof Session.RetryableAction ? new RetryableWrapperAction(action) : (action instanceof Session.TransactionalAction ? new TransactionalWrapperAction(action) : new WrapperAction(action));
    }

    @FunctionalInterface
    public static interface Action {
        public void run(CliSession var1) throws Exception;
    }

    private static class RetryableWrapperAction
    extends TransactionalWrapperAction
    implements Session.RetryableAction {
        RetryableWrapperAction(Action action) {
            super(action);
        }
    }

    private static class TransactionalWrapperAction
    extends WrapperAction
    implements Session.TransactionalAction,
    Session.HasTransactionOptions {
        TransactionalWrapperAction(Action action) {
            super(action);
        }

        public Map<String, ?> getTransactionOptions() {
            return this.action instanceof Session.HasTransactionOptions ? ((Session.HasTransactionOptions)this.action).getTransactionOptions() : null;
        }
    }

    private static class WrapperAction
    implements Session.Action {
        protected final Action action;

        WrapperAction(Action action) {
            this.action = action;
        }

        public void run(Session session) throws Exception {
            this.action.run((CliSession)session);
        }
    }
}

