/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.dellroad.stuff.java.ProcessRunner;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.CommandListParser;
import org.jsimpledb.cli.CommandParser;
import org.jsimpledb.cli.cmd.EvalCommand;
import org.jsimpledb.core.Database;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.util.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ConsoleReader console;
    protected final CliSession session;
    private final CommandParser commandParser = new CommandParser();
    private final CommandListParser commandListParser = new CommandListParser(this.commandParser);
    private FileHistory history;

    public Console(KVDatabase kvdb, InputStream input, OutputStream output) throws IOException {
        this(kvdb, null, null, input, output, null, null, null);
    }

    public Console(Database db, InputStream input, OutputStream output) throws IOException {
        this(null, db, null, input, output, null, null, null);
    }

    public Console(JSimpleDB jdb, InputStream input, OutputStream output) throws IOException {
        this(null, null, jdb, input, output, null, null, null);
    }

    public Console(KVDatabase kvdb, Database db, JSimpleDB jdb, InputStream input, OutputStream output, Terminal terminal, String encoding, String appName) throws IOException {
        Preconditions.checkArgument(((kvdb != null ? 1 : 0) + (db != null ? 1 : 0) + (jdb != null ? 1 : 0) == 1 ? 1 : 0) != 0, (Object)"exactly one of kvdb, db or jdb must be not null");
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        if (terminal == null) {
            terminal = Console.getTerminal();
        }
        this.console = new ConsoleReader(appName, input, output, terminal, encoding);
        this.console.setBellEnabled(true);
        this.console.setHistoryEnabled(true);
        this.console.setHandleUserInterrupt(true);
        this.console.setExpandEvents(false);
        PrintWriter writer = new PrintWriter(this.console.getOutput(), true);
        this.session = jdb != null ? new CliSession(jdb, writer, this) : (db != null ? new CliSession(db, writer, this) : new CliSession(kvdb, writer, this));
    }

    public ConsoleReader getConsoleReader() {
        return this.console;
    }

    public CliSession getSession() {
        return this.session;
    }

    public void setHistoryFile(File historyFile) throws IOException {
        Preconditions.checkArgument((historyFile != null ? 1 : 0) != 0, (Object)"null historyFile");
        FileHistory newHistory = new FileHistory(historyFile);
        if (this.history != null) {
            this.history.flush();
        }
        this.history = newHistory;
        this.console.setHistory((History)this.history);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runNonInteractive(Reader input, String inputDescription) throws IOException {
        boolean error;
        block7: {
            int r;
            StringWriter data = new StringWriter();
            char[] buf = new char[1024];
            while ((r = input.read(buf)) != -1) {
                data.write(buf, 0, r);
            }
            String text = data.toString();
            text = text.replaceAll("(?m)^[\\s&&[^\\n]]*#.*$", "");
            ParseContext ctx = new ParseContext(text);
            CliSession.Action[] action = new CliSession.Action[1];
            error = false;
            do {
                block8: {
                    ctx.skipWhitespace();
                    if (ctx.isEOF()) break block7;
                    String previousErrorMessagePrefix = this.session.getErrorMessagePrefix();
                    int lineNumber = text.substring(0, ctx.getIndex()).replaceAll("[^\\n]", "").length() + 1;
                    this.session.setErrorMessagePrefix(previousErrorMessagePrefix + (inputDescription != null ? inputDescription + ": " : "") + "line " + lineNumber + ": ");
                    try {
                        if (!this.session.performCliSessionAction(session -> {
                            action[0] = this.commandParser.parse(session, ctx, false);
                        })) {
                            error = true;
                            break block7;
                        }
                        if (this.session.performCliSessionAction(action[0]) && (!(action[0] instanceof EvalCommand.EvalAction) || ((EvalCommand.EvalAction)action[0]).getEvalException() == null)) break block8;
                        error = true;
                        break block7;
                    }
                    finally {
                        this.session.setErrorMessagePrefix(previousErrorMessagePrefix);
                    }
                }
                ctx.skipWhitespace();
                if (ctx.isEOF()) break block7;
            } while (ctx.tryLiteral(";"));
            this.session.reportException((Exception)((Object)new ParseException(ctx, "expected `;'")));
            error = true;
        }
        this.console.flush();
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        String prompt;
        StringBuilder lineBuffer = new StringBuilder();
        this.console.addCompleter((Completer)new ConsoleCompleter(lineBuffer));
        switch (this.session.getMode()) {
            case KEY_VALUE: {
                prompt = "KeyValue> ";
                break;
            }
            case CORE_API: {
                prompt = "CoreAPI> ";
                break;
            }
            case JSIMPLEDB: {
                prompt = "JSimpleDB> ";
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        try {
            this.console.println((CharSequence)("Welcome to JSimpleDB. You are in " + this.session.getMode() + " mode. Type `help' for help."));
            this.console.println();
            while (!this.session.isDone()) {
                CliSession.Action action;
                String line;
                try {
                    line = this.console.readLine(lineBuffer.length() == 0 ? prompt : String.format("%" + (prompt.length() - 3) + "s-> ", ""));
                }
                catch (UserInterruptException e) {
                    this.console.print((CharSequence)"^C");
                    line = null;
                }
                if (line == null) {
                    this.console.println();
                    break;
                }
                boolean continuation = false;
                if (line.length() > 0 && line.charAt(line.length() - 1) == '\\') {
                    line = line.substring(0, line.length() - 1) + "\n";
                    continuation = true;
                }
                lineBuffer.append(line);
                if (continuation) continue;
                ParseContext ctx = new ParseContext(lineBuffer.toString());
                ctx.skipWhitespace();
                if (ctx.getInput().length() == 0) continue;
                ArrayList actions = new ArrayList();
                boolean[] needMoreInput = new boolean[1];
                boolean ok = this.session.performCliSessionAction(session -> {
                    try {
                        actions.addAll(this.commandListParser.parse(session, ctx, false));
                    }
                    catch (ParseException e) {
                        if (ctx.getInput().length() == 0) {
                            needMoreInput[0] = true;
                        }
                        throw e;
                    }
                });
                if (needMoreInput[0]) {
                    lineBuffer.append('\n');
                    continue;
                }
                lineBuffer.setLength(0);
                if (!ok) continue;
                Iterator iterator = actions.iterator();
                while (iterator.hasNext() && this.session.performCliSessionAction(action = (CliSession.Action)iterator.next())) {
                }
                this.console.flush();
            }
        }
        finally {
            if (this.history != null) {
                this.history.flush();
            }
            this.console.flush();
            this.console.shutdown();
        }
    }

    public List<CliSession.Action> parseCommand(String text) {
        Preconditions.checkArgument((text != null ? 1 : 0) != 0, (Object)"null text");
        ParseContext ctx = new ParseContext(text);
        ArrayList<CliSession.Action> actions = new ArrayList<CliSession.Action>();
        return this.session.performCliSessionAction(session -> actions.addAll((Collection<CliSession.Action>)this.commandListParser.parse(session, ctx, false))) ? actions : null;
    }

    public static Terminal getTerminal() throws IOException {
        block8: {
            boolean windows = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
            if (windows) {
                ProcessRunner runner;
                try {
                    runner = new ProcessRunner(Runtime.getRuntime().exec(new String[]{"uname", "-s"}));
                }
                catch (IOException e) {
                    break block8;
                }
                runner.setDiscardStandardError(true);
                try {
                    runner.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break block8;
                }
                if (new String(runner.getStandardOutput(), StandardCharsets.UTF_8).trim().matches("(?is)^cygwin.*")) {
                    try {
                        return TerminalFactory.getFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX);
                    }
                    catch (Exception e) {}
                    {
                    }
                }
            }
        }
        return TerminalFactory.get();
    }

    private class ConsoleCompleter
    implements Completer {
        private final StringBuilder lineBuffer;

        ConsoleCompleter(StringBuilder lineBuffer) {
            this.lineBuffer = lineBuffer;
        }

        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            ParseContext ctx = new ParseContext(this.lineBuffer + buffer.substring(0, cursor));
            try {
                Console.this.commandListParser.parse(Console.this.session, ctx, true);
            }
            catch (ParseException e) {
                String prefix = "";
                int index = ctx.getIndex();
                while (index > 0 && Character.isJavaIdentifierPart(ctx.getOriginalInput().charAt(index - 1))) {
                    prefix = ctx.getOriginalInput().charAt(--index) + prefix;
                }
                String prefix0 = prefix;
                candidates.addAll(Lists.transform((List)e.getCompletions(), string -> prefix0 + string));
                return index;
            }
            catch (Exception e) {
                try {
                    Console.this.console.println();
                    Console.this.console.println((CharSequence)"Error: got exception calculating command line completions");
                    e.printStackTrace(Console.this.session.getWriter());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return cursor;
        }
    }
}

