/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.WordParser;
import org.jsimpledb.util.ParseContext;

public class ParamParser
implements Parser<Map<String, Object>> {
    private final LinkedHashSet<Param> optionFlags = new LinkedHashSet();
    private final ArrayList<Param> params = new ArrayList();
    private final FieldTypeRegistry fieldTypeRegistry = new FieldTypeRegistry();

    public ParamParser(String spec) {
        if (spec.length() > 0) {
            for (String pspec : spec.split("\\s+")) {
                Param param = new Param(pspec);
                if (param.isOption()) {
                    this.optionFlags.add(param);
                    continue;
                }
                this.params.add(param);
            }
        }
    }

    public String getUsage(String commandName) {
        StringBuilder buf = new StringBuilder(commandName);
        for (Param param : this.optionFlags) {
            buf.append(" [").append(param.getOptionFlag());
            if (param.getTypeName() != null) {
                buf.append(' ').append(param.getName());
            }
            buf.append(']');
        }
        for (Param param : this.params) {
            buf.append(' ');
            if (param.getMin() == 0) {
                buf.append('[');
            }
            buf.append(param.getName());
            if (param.getMax() > 1) {
                buf.append(" ...");
            }
            if (param.getMin() != 0) continue;
            buf.append(']');
        }
        return buf.toString();
    }

    public Set<Param> getOptionFlags() {
        return this.optionFlags;
    }

    public List<Param> getParameters() {
        return this.params;
    }

    protected Parser<?> getParser(String typeName) {
        Preconditions.checkArgument((typeName != null ? 1 : 0) != 0, (Object)"null typeName");
        if (typeName.equals("word")) {
            return new WordParser("parameter");
        }
        FieldType fieldType = this.fieldTypeRegistry.getFieldType(typeName);
        if (fieldType != null) {
            return (session, ctx, complete) -> {
                try {
                    return fieldType.fromParseableString(ctx);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(ctx, "invalid " + fieldType.getName() + " value", (Throwable)e);
                }
            };
        }
        throw new IllegalArgumentException("unknown parameter type `" + typeName + "'");
    }

    public Map<String, Object> parse(ParseSession session, ParseContext ctx, boolean complete) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        boolean needSpace = !this.params.isEmpty() && this.params.get(0).getMin() > 0;
        while (true) {
            new SpaceParser(needSpace).parse(ctx, complete);
            needSpace = false;
            if (ctx.getInput().matches("(?s)^--([\\s;].*)?$")) {
                ctx.setIndex(ctx.getIndex() + 2);
                needSpace = !this.params.isEmpty() && this.params.get(0).getMin() > 0;
                break;
            }
            Matcher matcher = ctx.tryPattern("(-[^\\s;]+)");
            if (matcher == null) break;
            String option = matcher.group(1);
            Param param = this.optionFlags.stream().filter(p -> option.equals(p.getOptionFlag())).findAny().orElseThrow(() -> new ParseException(ctx, "unrecognized option `" + option + "'").addCompletions(ParseUtil.complete(this.optionFlags.stream().map(Param::getOptionFlag), (String)option)));
            Parser<?> parser = param.getParser();
            if (parser != null) {
                new SpaceParser(true).parse(ctx, complete);
                values.put(param.getName(), parser.parse(session, ctx, complete));
            } else {
                values.put(param.getName(), true);
            }
            needSpace = !this.params.isEmpty() && this.params.get(0).getMin() > 0;
        }
        for (Param param : this.params) {
            ArrayList<Object> paramValues = new ArrayList<Object>();
            String typeName = param.getTypeName();
            Parser<?> parser = param.getParser();
            while (paramValues.size() < param.getMax()) {
                new SpaceParser(needSpace).parse(ctx, complete);
                needSpace = false;
                if (!ctx.getInput().matches("(?s)^[^\\s;].*$")) {
                    if (!complete) break;
                    parser.parse(session, new ParseContext(""), true);
                    throw new ParseException(ctx, "");
                }
                paramValues.add(parser.parse(session, ctx, complete));
                needSpace = paramValues.size() < param.getMin();
            }
            if (paramValues.size() < param.getMin()) {
                ParseException e = new ParseException(ctx, "missing `" + param.getName() + "' parameter");
                if (complete) {
                    try {
                        parser.parse(session, new ParseContext(""), true);
                    }
                    catch (ParseException e2) {
                        e.addCompletions((Iterable)e2.getCompletions());
                    }
                }
                throw e;
            }
            if (param.getMax() > 1) {
                values.put(param.getName(), Arrays.asList(paramValues.toArray()));
                continue;
            }
            if (paramValues.isEmpty()) continue;
            values.put(param.getName(), paramValues.get(0));
        }
        new SpaceParser().parse(ctx, complete);
        if (!ctx.getInput().matches("(?s)^(;.*)?$")) {
            throw new ParseException(ctx);
        }
        return values;
    }

    public class Param {
        private final String optionFlag;
        private final String name;
        private final String typeName;
        private final Parser<?> parser;
        private final int min;
        private final int max;

        public Param(String spec) {
            Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (Object)"null spec");
            Pattern pattern = Pattern.compile("((-[^\\s:]+):)?([^-][^\\s:?+*]*)(:([^\\s?+*]+))?([?+*])?");
            Matcher matcher = pattern.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid parameter spec `" + spec + "'");
            }
            this.optionFlag = matcher.group(2);
            this.name = matcher.group(3);
            this.typeName = matcher.group(5);
            String repeat = matcher.group(6);
            if (repeat == null) {
                this.min = 1;
                this.max = 1;
            } else if (repeat.charAt(0) == '?') {
                this.min = 0;
                this.max = 1;
            } else if (repeat.charAt(0) == '*') {
                this.min = 0;
                this.max = Integer.MAX_VALUE;
            } else if (repeat.charAt(0) == '+') {
                this.min = 1;
                this.max = Integer.MAX_VALUE;
            } else {
                throw new IllegalArgumentException("invalid parameter spec `" + spec + "'");
            }
            this.parser = this.typeName != null ? ParamParser.this.getParser(this.typeName) : (!this.isOption() ? new WordParser("parameter") : null);
        }

        public String getOptionFlag() {
            return this.optionFlag;
        }

        public boolean isOption() {
            return this.optionFlag != null;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public Parser<?> getParser() {
            return this.parser;
        }

        public String toString() {
            return (this.optionFlag != null ? this.optionFlag + ":" : "") + this.name + (this.typeName != null ? ":" + this.typeName : "") + (this.min == 0 && this.max == 1 ? "?" : (this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : "")));
        }
    }
}

