/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.ParamParser;
import org.jsimpledb.cli.cmd.Command;
import org.jsimpledb.parse.FieldTypeParser;
import org.jsimpledb.parse.ObjIdParser;
import org.jsimpledb.parse.ObjTypeParser;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.util.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected final ParamParser paramParser;

    protected AbstractCommand(String spec) {
        Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (Object)"null spec");
        Matcher matcher = Pattern.compile("([^\\s]+)(\\s+(.*))?").matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid command specification `" + spec + "'");
        }
        this.name = matcher.group(1);
        String paramSpec = matcher.group(3);
        this.paramParser = new ParamParser(paramSpec != null ? paramSpec : ""){

            @Override
            protected Parser<?> getParser(String typeName) {
                try {
                    return super.getParser(typeName);
                }
                catch (IllegalArgumentException e) {
                    return AbstractCommand.this.getParser(typeName);
                }
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUsage() {
        return this.paramParser.getUsage(this.name);
    }

    @Override
    public abstract String getHelpSummary();

    @Override
    public String getHelpDetail() {
        return this.getHelpSummary();
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.of(SessionMode.CORE_API, SessionMode.JSIMPLEDB);
    }

    public CliSession.Action parse(ParseSession session, ParseContext ctx, boolean complete) {
        Preconditions.checkArgument((boolean)(session instanceof CliSession), (Object)"session is not a CliSession");
        return this.getAction((CliSession)session, ctx, complete, (Map<String, Object>)this.paramParser.parse(session, ctx, complete));
    }

    protected abstract CliSession.Action getAction(CliSession var1, ParseContext var2, boolean var3, Map<String, Object> var4);

    protected Parser<?> getParser(String typeName) {
        Preconditions.checkArgument((typeName != null ? 1 : 0) != 0, (Object)"null typeName");
        if (typeName.equals("type")) {
            return new ObjTypeParser();
        }
        if (typeName.equals("objid")) {
            return new ObjIdParser();
        }
        if (typeName.equals("expr")) {
            return new ExprParser();
        }
        return FieldTypeParser.getFieldTypeParser((String)typeName);
    }

    protected <T> T getExprParam(CliSession session, Node node, String name, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        return (T)this.getExprParam(session, node, name, (Object obj) -> {
            if (!type.isInstance(obj)) {
                throw new IllegalArgumentException("must be of type " + type.getName() + " (found " + (obj != null ? obj.getClass().getName() : "null") + ")");
            }
            return type.cast(obj);
        });
    }

    protected <T> T getExprParam(CliSession session, Node node, String name, Function<Object, T> validator) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"null node");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((validator != null ? 1 : 0) != 0, (Object)"null validator");
        Object value = node.evaluate((ParseSession)session).get((ParseSession)session);
        try {
            return validator.apply(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid `" + name + "' parameter: " + e.getMessage());
        }
    }
}

