/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import jline.console.completer.FileNameCompleter;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.util.ParseCastFunction;
import org.jsimpledb.util.ParseContext;

abstract class AbstractFileParser
implements Parser<File> {
    AbstractFileParser() {
    }

    public File parse(ParseSession session, ParseContext ctx, boolean complete) {
        Matcher matcher = ctx.tryPattern("[^\\s;]*");
        if (matcher == null) {
            throw new ParseException(ctx);
        }
        String path = matcher.group();
        File file = new File(path);
        if (!complete && this.validateFile(file, complete)) {
            return file;
        }
        ParseException e = this.createParseException(ctx, file);
        if (complete) {
            ArrayList list = new ArrayList();
            int index = new FileNameCompleter().complete(path, path.length(), list);
            if (index != -1) {
                int suffixLength = path.length() - index;
                e.addCompletions(list.stream().map(new ParseCastFunction(String.class)).map(string -> string.substring(suffixLength)));
            }
        }
        throw e;
    }

    protected abstract boolean validateFile(File var1, boolean var2);

    protected abstract ParseException createParseException(ParseContext var1, File var2);
}

