/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.Session;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class EvalCommand
extends AbstractCommand {
    public EvalCommand() {
        super("eval -f:force -w:weak expr:expr");
    }

    @Override
    public String getHelpSummary() {
        return "Evaluates the specified Java expression";
    }

    @Override
    public String getHelpDetail() {
        return "The expression is evaluated within a transaction. If an exception occurs, the transaction is rolled back unless the `-f' flag is given, in which case it will be committed anyway.\nIf the `-w' flag is given, for certain key/value stores a weaker consistency level is used for the tranasction to reduce the chance of conflicts.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    public EvalAction getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        Node expr = (Node)params.get("expr");
        boolean force = params.containsKey("force");
        boolean weak = params.containsKey("weak");
        return new EvalAction(expr, force, weak);
    }

    public static final class EvalAction
    implements CliSession.Action,
    Session.TransactionalAction,
    Session.HasTransactionOptions {
        private final Node expr;
        private final boolean force;
        private final boolean weak;
        private EvalException evalException;

        private EvalAction(Node expr, boolean force, boolean weak) {
            this.expr = expr;
            this.force = force;
            this.weak = weak;
        }

        @Override
        public void run(CliSession session) throws Exception {
            Object result;
            Value value;
            PrintWriter writer = session.getWriter();
            try {
                value = this.expr.evaluate((ParseSession)session);
                result = value.get((ParseSession)session);
            }
            catch (EvalException e) {
                this.evalException = e;
                if (!this.force && session.getMode().hasCoreAPI()) {
                    session.getTransaction().setRollbackOnly();
                }
                writer.println(session.getErrorMessagePrefix() + e.getMessage());
                if (session.isVerbose()) {
                    e.printStackTrace(writer);
                }
                return;
            }
            if (value != Value.NO_VALUE) {
                writer.println(result);
            }
        }

        public Map<String, ?> getTransactionOptions() {
            return this.weak ? Collections.singletonMap("consistency", "EVENTUAL") : null;
        }

        public EvalException getEvalException() {
            return this.evalException;
        }
    }
}

