/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.cli.cmd.Command;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.WordParser;
import org.jsimpledb.parse.func.Function;
import org.jsimpledb.util.ParseContext;

public class HelpCommand
extends AbstractCommand {
    private final CliSession session;

    public HelpCommand(CliSession session) {
        super("help -a:all command-or-function:cmdfunc?");
        this.session = session;
    }

    @Override
    public String getHelpSummary() {
        return "Display help information";
    }

    @Override
    public String getHelpDetail() {
        return "Displays the list of known commands and functions, or help information about a specific command or function.\nNormally only those appropriate for the current session mode are listed; use `-a' to show all.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    protected Parser<?> getParser(String typeName) {
        if ("cmdfunc".equals(typeName)) {
            return new WordParser("command/function"){

                protected HashSet<String> getWords() {
                    HashSet<String> names = new HashSet<String>();
                    names.addAll(HelpCommand.this.session.getCommands().keySet());
                    names.addAll(HelpCommand.this.session.getFunctions().keySet());
                    return names;
                }
            };
        }
        return super.getParser(typeName);
    }

    @Override
    public CliSession.Action getAction(CliSession session0, ParseContext ctx, boolean complete, Map<String, Object> params) {
        boolean all = params.containsKey("all");
        String name = (String)params.get("command-or-function");
        SessionMode sessionMode = this.session.getMode();
        return session -> {
            PrintWriter writer = session.getWriter();
            if (name == null) {
                writer.println((all ? "All" : "Available") + " commands:");
                session.getCommands().values().stream().filter(command -> all || command.getSessionModes().contains(sessionMode)).forEach(command -> writer.println(String.format("%24s - %s", command.getName(), command.getHelpSummary())));
                writer.println((all ? "All" : "Available") + " functions:");
                session.getFunctions().values().stream().filter(function -> all || function.getSessionModes().contains(sessionMode)).forEach(function -> writer.println(String.format("%24s - %s", function.getName(), function.getHelpSummary())));
            } else {
                Function function2;
                Command command2 = (Command)session.getCommands().get(name);
                if (command2 != null) {
                    writer.println("Usage: " + command2.getUsage());
                    writer.println(command2.getHelpDetail());
                    writer.println("Supported session modes: " + command2.getSessionModes().toString().replaceAll("\\[(.*)\\]", "$1"));
                }
                if ((function2 = (Function)session.getFunctions().get(name)) != null) {
                    writer.println("Usage: " + function2.getUsage());
                    writer.println(function2.getHelpDetail());
                    writer.println("Supported session modes: " + function2.getSessionModes().toString().replaceAll("\\[(.*)\\]", "$1"));
                }
                if (command2 == null && function2 == null) {
                    writer.println("No command or function named `" + name + "' exists.");
                }
            }
        };
    }
}

