/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.Session;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractKVCommand;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.ParseContext;

public class KVGetCommand
extends AbstractKVCommand {
    public KVGetCommand() {
        super("kvget -n:novals -s:cstrings -range:range key:bytes maxKey:bytes? limit:int?");
    }

    @Override
    public String getHelpSummary() {
        return "Retrieves one, or a range, of raw database key/value pairs to the console";
    }

    @Override
    public String getHelpDetail() {
        return "Retrieves a single raw database key/value pair, or a range of key/value pairs, to the console.\nIf `-range' is not given, a single key/value pair is retrieved. Otherwise, `key' is the minimum key (inclusive) and `maxKey' is the maximum key (exclusive) if given, otherwise there is no maximum key. `key' and `maxKey' may be given as hexadecimal strings or C-style doubly-quoted strings.\nThe `limit' parameter limits the total number of key/value pairs displayed.\nBy default, keys and values are displayed in hexadecimal with an ASCII decoding; use the `-s' flag to display keys and values directly as C-style doubly-quoted strings.\nThe `-n' flag causes only keys (not values) to be displayed.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    public CliSession.Action getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        boolean cstrings = params.containsKey("cstrings");
        boolean range = params.containsKey("range");
        boolean novals = params.containsKey("novals");
        byte[] key = (byte[])params.get("key");
        byte[] maxKey = (byte[])params.get("maxKey");
        Integer limit = (Integer)params.get("limit");
        if (maxKey != null && !range) {
            throw new ParseException(ctx, "`-range' must be specified to retrieve a range of keys");
        }
        return new GetAction(cstrings, range, novals, key, maxKey, limit);
    }

    private static void decode(PrintWriter writer, String prefix, byte[] value) {
        for (int i = 0; i < value.length; i += 32) {
            int j;
            writer.print(prefix);
            for (j = 0; j < 32; ++j) {
                writer.print(i + j < value.length ? String.format("%02x", value[i + j] & 0xFF) : "  ");
                if (j % 4 != 3) continue;
                writer.print(' ');
            }
            writer.print("   ");
            for (j = 0; j < 32 && i + j < value.length; ++j) {
                int ch = value[i + j] & 0xFF;
                writer.print(i + j < value.length ? (char)(ch < 32 || ch > 127 ? 46 : (char)ch) : (char)32);
            }
            writer.println();
        }
    }

    private static class GetAction
    implements CliSession.Action,
    Session.TransactionalAction {
        private final boolean cstrings;
        private final boolean range;
        private final boolean novals;
        private final byte[] key;
        private final byte[] maxKey;
        private final Integer limit;

        GetAction(boolean cstrings, boolean range, boolean novals, byte[] key, byte[] maxKey, Integer limit) {
            this.cstrings = cstrings;
            this.range = range;
            this.novals = novals;
            this.key = key;
            this.maxKey = maxKey;
            this.limit = limit;
        }

        @Override
        public void run(CliSession session) throws Exception {
            PrintWriter writer = session.getWriter();
            KVTransaction kvt = session.getKVTransaction();
            if (!this.range) {
                byte[] value = kvt.get(this.key);
                writer.println(value != null && this.cstrings ? AbstractKVCommand.toCString(value) : ByteUtil.toString((byte[])value));
                return;
            }
            long count = 0L;
            try (CloseableIterator i = kvt.getRange(this.key, this.maxKey);){
                while (i.hasNext()) {
                    KVPair pair = (KVPair)i.next();
                    if (this.limit != null && count >= (long)this.limit.intValue()) {
                        break;
                    }
                    if (this.cstrings) {
                        writer.println("K " + AbstractKVCommand.toCString(pair.getKey()));
                        if (!this.novals) {
                            writer.println("V " + AbstractKVCommand.toCString(pair.getValue()));
                        }
                    } else {
                        KVGetCommand.decode(writer, "K ", pair.getKey());
                        if (!this.novals) {
                            KVGetCommand.decode(writer, "V ", pair.getValue());
                        }
                    }
                    ++count;
                }
            }
            writer.println("Displayed " + count + " key/value pairs");
        }
    }
}

