/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.func.Function;
import org.jsimpledb.util.ParseContext;

public class RegisterFunctionCommand
extends AbstractCommand {
    public RegisterFunctionCommand() {
        super("register-function class:expr");
    }

    @Override
    public String getHelpSummary() {
        return "Instantiates a user-supplied class implementing the Function interface and registers it as an available function.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    public CliSession.Action getAction(CliSession session0, ParseContext ctx, boolean complete, Map<String, Object> params) {
        Node expr = (Node)params.get("class");
        return session -> {
            Class functionClass = this.getExprParam(session, expr, "class", (Object obj) -> {
                if (!(obj instanceof Class)) {
                    throw new IllegalArgumentException("not a " + Class.class.getName() + " instance");
                }
                Class cl = (Class)obj;
                if (!Function.class.isAssignableFrom(cl)) {
                    throw new IllegalArgumentException(cl + " does not implement " + Function.class);
                }
                return cl.asSubclass(Function.class);
            });
            Function function = (Function)functionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            session.registerFunction(function);
            session.getWriter().println("Registered function `" + function.getName() + "'");
        };
    }
}

