/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.func;

import java.io.PrintWriter;
import org.jsimpledb.JObject;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.func.SimpleCliFunction;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.util.ObjDumper;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;

public class DumpFunction
extends SimpleCliFunction {
    public DumpFunction() {
        super("dump", 1, 1);
    }

    public String getHelpSummary() {
        return "Prints all fields of the given database object to the console";
    }

    public String getUsage() {
        return "dump(expr)";
    }

    @Override
    protected Value apply(CliSession session, Value[] params) {
        Object obj = params[0].checkNotNull((ParseSession)session, "dump()");
        if (obj instanceof JObject) {
            obj = ((JObject)obj).getObjId();
        } else if (!(obj instanceof ObjId)) {
            throw new EvalException("invalid dump() operation on non-database object of type " + obj.getClass().getName());
        }
        ObjId id = (ObjId)obj;
        this.dump(session, id);
        return Value.NO_VALUE;
    }

    private void dump(CliSession session, ObjId id) {
        Transaction tx = session.getTransaction();
        PrintWriter writer = session.getWriter();
        if (!tx.exists(id)) {
            writer.println("object " + id + " (does not exist)");
            return;
        }
        ObjDumper.print((PrintWriter)writer, (Transaction)tx, (ObjId)id, (int)session.getLineLimit());
    }
}

