/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.array.ArrayKVFinder;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

public class ArrayKVStore
extends AbstractKVStore {
    private final int size;
    private final ArrayKVFinder finder;

    public ArrayKVStore(ByteBuffer indx, ByteBuffer keys, ByteBuffer vals) {
        Preconditions.checkArgument((indx != null ? 1 : 0) != 0, (Object)"null indx");
        Preconditions.checkArgument((keys != null ? 1 : 0) != 0, (Object)"null keys");
        Preconditions.checkArgument((vals != null ? 1 : 0) != 0, (Object)"null vals");
        Preconditions.checkArgument((indx.capacity() % 8 == 0 ? 1 : 0) != 0, (Object)"index size is not a multiple of 8");
        this.size = indx.capacity() / 8;
        this.finder = new ArrayKVFinder(indx, keys, vals);
    }

    public byte[] get(byte[] key) {
        int index = this.finder.find(key);
        if (index < 0) {
            return null;
        }
        return this.finder.readValue(index);
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        int index;
        if (minKey == null || minKey.length == 0) {
            index = 0;
        } else {
            index = this.finder.find(minKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        if (index == this.size) {
            return null;
        }
        KVPair pair = this.finder.readKV(index);
        assert (ByteUtil.compare((byte[])pair.getKey(), (byte[])minKey) >= 0);
        return maxKey == null || ByteUtil.compare((byte[])pair.getKey(), (byte[])maxKey) < 0 ? pair : null;
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        int index;
        if (maxKey == null) {
            index = this.size;
        } else {
            index = this.finder.find(maxKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        if (index == 0) {
            return null;
        }
        KVPair pair = this.finder.readKV(index - 1);
        assert (ByteUtil.compare((byte[])pair.getKey(), (byte[])maxKey) < 0);
        return minKey == null || ByteUtil.compare((byte[])pair.getKey(), (byte[])minKey) >= 0 ? pair : null;
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        int index;
        if (minKey == null || minKey.length == 0) {
            index = 0;
        } else {
            index = this.finder.find(minKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        int minIndex = index;
        if (maxKey == null) {
            index = this.size;
        } else {
            index = this.finder.find(maxKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        int maxIndex = index;
        return new RangeIter(minIndex, maxIndex, reverse);
    }

    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public void remove(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException();
    }

    private class RangeIter
    extends UnmodifiableIterator<KVPair>
    implements CloseableIterator<KVPair> {
        private final int limit;
        private final boolean reverse;
        private int index;

        RangeIter(int minIndex, int maxIndex, boolean reverse) {
            this.index = reverse ? maxIndex : minIndex;
            this.limit = reverse ? minIndex : maxIndex;
            this.reverse = reverse;
        }

        public boolean hasNext() {
            return this.reverse ? this.index > this.limit : this.index < this.limit;
        }

        public KVPair next() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ArrayKVFinder arrayKVFinder = ArrayKVStore.this.finder;
            if (this.reverse) {
                n = this.index = this.index - 1;
            } else {
                int n2 = this.index;
                n = n2;
                this.index = n2 + 1;
            }
            return arrayKVFinder.readKV(n);
        }

        public void close() {
        }
    }
}

