/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

public class KVPairIterator
implements CloseableIterator<KVPair> {
    private final KVStore kv;
    private final boolean reverse;
    private final KeyRange keyRange;
    private final KeyFilter keyFilter;
    private KVPair currPair;
    private byte[] nextKey;
    private byte[] removeKey;
    private boolean finished;

    public KVPairIterator(KVStore kv, KeyRange keyRange) {
        this(kv, keyRange, null, false);
    }

    public KVPairIterator(KVStore kv, byte[] prefix) {
        this(kv, prefix, false);
    }

    public KVPairIterator(KVStore kv, byte[] prefix, boolean reverse) {
        this(kv, KeyRange.forPrefix(prefix), null, reverse);
    }

    public KVPairIterator(KVStore kv, KeyRange keyRange, KeyFilter keyFilter, boolean reverse) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
        this.keyRange = keyRange;
        this.keyFilter = keyFilter;
        this.reverse = reverse;
        this.setNextTarget(null);
    }

    public KVStore getKVStore() {
        return this.kv;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    public KeyFilter getKeyFilter() {
        return this.keyFilter;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean isVisible(byte[] key) {
        Preconditions.checkArgument((this.kv != null ? 1 : 0) != 0, (Object)"null kv");
        return !(this.keyRange != null && !this.keyRange.contains(key) || this.keyFilter != null && !this.keyFilter.contains(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextTarget(byte[] targetKey) {
        if (targetKey != null) {
            targetKey = (byte[])targetKey.clone();
        }
        if (this.keyRange != null) {
            if (this.reverse) {
                byte[] maxKey = this.keyRange.getMax();
                if (maxKey != null && (targetKey == null || ByteUtil.compare((byte[])targetKey, (byte[])maxKey) > 0)) {
                    targetKey = maxKey;
                }
            } else {
                byte[] minKey = this.keyRange.getMin();
                if (targetKey == null || ByteUtil.compare((byte[])targetKey, (byte[])minKey) < 0) {
                    targetKey = minKey;
                }
            }
        }
        KVPairIterator kVPairIterator = this;
        synchronized (kVPairIterator) {
            this.nextKey = targetKey;
            this.finished = false;
            this.currPair = null;
        }
    }

    public synchronized boolean hasNext() {
        KVPair pair;
        block7: {
            if (this.currPair != null) {
                return true;
            }
            if (this.finished) {
                return false;
            }
            do {
                if ((this.reverse ? this.kv.getAtMost(this.nextKey, this.keyRange != null ? this.keyRange.getMin() : null) : (pair = this.kv.getAtLeast(this.nextKey, this.keyRange != null ? this.keyRange.getMax() : null))) == null) {
                    this.finished = true;
                    return false;
                }
                byte[] key = pair.getKey();
                if (this.keyRange != null && !this.keyRange.contains(key)) {
                    this.finished = true;
                    return false;
                }
                if (this.keyFilter == null) break block7;
                if (!this.reverse) {
                    byte[] nextHigher = this.keyFilter.seekHigher(key);
                    if (nextHigher == null || !Arrays.equals(nextHigher, key)) {
                        this.nextKey = nextHigher;
                        continue;
                    }
                    break block7;
                }
                if (this.keyFilter.contains(key)) break block7;
                byte[] byArray = this.nextKey = key.length > 0 ? this.keyFilter.seekLower(key) : null;
            } while (this.nextKey != null);
            this.finished = true;
            return false;
        }
        this.currPair = pair;
        return true;
    }

    public synchronized KVPair next() {
        if (this.currPair == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        KVPair pair = this.currPair;
        byte[] key = (byte[])pair.getKey().clone();
        this.removeKey = key;
        this.nextKey = this.reverse ? key : ByteUtil.getNextKey((byte[])key);
        this.currPair = null;
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        byte[] removeKeyCopy;
        KVPairIterator kVPairIterator = this;
        synchronized (kVPairIterator) {
            removeKeyCopy = this.removeKey;
            if (this.removeKey == null) {
                throw new IllegalStateException();
            }
            this.removeKey = null;
        }
        this.kv.remove(removeKeyCopy);
    }

    public void close() {
    }
}

