/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.KeyListEncoder;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ImmutableNavigableSet;
import org.jsimpledb.util.UnsignedIntEncoder;

public class KeyRanges
implements Iterable<KeyRange>,
KeyFilter,
Cloneable {
    private NavigableSet<KeyRange> ranges;
    private transient KeyRange lastContainingKeyRange;

    public KeyRanges(Iterable<? extends KeyRange> ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        this.ranges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
        for (KeyRange keyRange : ranges) {
            Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"null range");
            this.add(keyRange);
        }
        assert (this.checkMinimal());
    }

    public KeyRanges(Stream<? extends KeyRange> ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        this.ranges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
        ranges.peek(range -> Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range")).forEach(this::add);
        assert (this.checkMinimal());
    }

    public KeyRanges(KeyRange ... ranges) {
        this(Arrays.asList(ranges));
    }

    public KeyRanges(KeyRanges ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        this.ranges = new TreeSet<KeyRange>((SortedSet<KeyRange>)ranges.ranges);
        this.lastContainingKeyRange = ranges.lastContainingKeyRange;
        assert (this.checkMinimal());
    }

    public KeyRanges(KeyRange range) {
        this.ranges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
        if (!range.isEmpty()) {
            this.ranges.add(range);
        }
        assert (this.checkMinimal());
    }

    public KeyRanges(byte[] key) {
        this.ranges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
        this.ranges.add(new KeyRange(key));
        assert (this.checkMinimal());
    }

    public KeyRanges(byte[] min, byte[] max) {
        this(new KeyRange(min, max));
    }

    public KeyRanges(InputStream input) throws IOException {
        this(input, false);
    }

    public KeyRanges(InputStream input, boolean immutable) throws IOException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        int count = UnsignedIntEncoder.read((InputStream)input);
        Object[] array = new KeyRange[count];
        byte[] prev = null;
        for (int i = 0; i < count; ++i) {
            byte[] min = KeyListEncoder.read(input, prev);
            byte[] max = KeyListEncoder.read(input, min);
            Preconditions.checkArgument((prev == null || ByteUtil.compare((byte[])min, prev) > 0 ? 1 : 0) != 0, (Object)"invalid input");
            array[i] = new KeyRange(min, Arrays.equals(min, max) ? null : max);
            prev = max;
        }
        if (immutable) {
            this.ranges = new ImmutableNavigableSet(array, KeyRange.SORT_BY_MIN);
        } else {
            this.ranges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
            this.ranges.addAll(Arrays.asList(array));
        }
        assert (this.checkMinimal());
    }

    private KeyRanges(NavigableSet<KeyRange> ranges) {
        assert (ranges != null);
        this.ranges = ranges;
        assert (this.checkMinimal());
    }

    public static KeyRanges forPrefix(byte[] prefix) {
        return new KeyRanges(KeyRange.forPrefix(prefix));
    }

    public static KeyRanges empty() {
        return new KeyRanges(new KeyRange[0]);
    }

    public static KeyRanges full() {
        return new KeyRanges(KeyRange.FULL);
    }

    public List<KeyRange> asList() {
        assert (this.checkMinimal());
        return new ArrayList<KeyRange>(this.ranges);
    }

    public NavigableSet<KeyRange> asSet() {
        assert (this.checkMinimal());
        return this.ranges instanceof ImmutableNavigableSet ? this.ranges : Collections.unmodifiableNavigableSet(this.ranges);
    }

    public int size() {
        assert (this.checkMinimal());
        return this.ranges.size();
    }

    public void clear() {
        assert (this.checkMinimal());
        this.ranges.clear();
    }

    public boolean isEmpty() {
        assert (this.checkMinimal());
        return this.ranges.isEmpty();
    }

    public boolean isFull() {
        assert (this.checkMinimal());
        return !this.ranges.isEmpty() && ((KeyRange)this.ranges.first()).isFull();
    }

    public byte[] getMin() {
        assert (this.checkMinimal());
        return !this.ranges.isEmpty() ? ((KeyRange)this.ranges.first()).getMin() : null;
    }

    public byte[] getMax() {
        assert (this.checkMinimal());
        return !this.ranges.isEmpty() ? ((KeyRange)this.ranges.last()).getMax() : null;
    }

    public KeyRanges prefixedBy(byte[] prefix) {
        assert (this.checkMinimal());
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        return new KeyRanges(this.ranges.stream().map(range -> range.prefixedBy(prefix)));
    }

    public KeyRanges inverse() {
        assert (this.checkMinimal());
        Iterator<KeyRange> i = this.ranges.iterator();
        if (!i.hasNext()) {
            return KeyRanges.full();
        }
        TreeSet<KeyRange> inverseRanges = new TreeSet<KeyRange>(KeyRange.SORT_BY_MIN);
        KeyRange first = i.next();
        byte[] lastMax = first.max;
        if (first.min.length > 0) {
            inverseRanges.add(new KeyRange(ByteUtil.EMPTY, first.min));
        }
        while (lastMax != null) {
            if (!i.hasNext()) {
                inverseRanges.add(new KeyRange(lastMax, null));
                break;
            }
            KeyRange next = i.next();
            inverseRanges.add(new KeyRange(lastMax, next.min));
            lastMax = next.max;
        }
        return new KeyRanges((NavigableSet<KeyRange>)inverseRanges);
    }

    public boolean contains(KeyRanges ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        assert (this.checkMinimal());
        for (KeyRange range : ranges.ranges) {
            if (this.contains(range)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        assert (this.checkMinimal());
        KeyRange[] neighbors = this.findKey(range.min);
        if (neighbors[0] != neighbors[1] || neighbors[0] == null) {
            return false;
        }
        KeyRange match = neighbors[0];
        return match.contains(range);
    }

    public boolean intersects(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        assert (this.checkMinimal());
        KeyRange searchKey = new KeyRange(range.min, range.min);
        assert (!this.ranges.contains(searchKey));
        KeyRange lower = this.ranges.lower(searchKey);
        if (lower != null && KeyRange.compare(lower.max, range.min) > 0) {
            return true;
        }
        KeyRange higher = this.ranges.higher(searchKey);
        return higher != null && KeyRange.compare(higher.min, range.max) < 0;
    }

    public KeyRange[] findKey(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        assert (this.checkMinimal());
        KeyRange likelyKeyRange = this.lastContainingKeyRange;
        if (likelyKeyRange != null) {
            if (likelyKeyRange.contains(key) && this.ranges.contains(likelyKeyRange)) {
                return new KeyRange[]{likelyKeyRange, likelyKeyRange};
            }
            this.lastContainingKeyRange = null;
        }
        KeyRange searchKey = new KeyRange(key, key);
        assert (!this.ranges.contains(searchKey));
        KeyRange lower = this.ranges.lower(searchKey);
        if (lower != null && lower.contains(key)) {
            this.lastContainingKeyRange = lower;
            return new KeyRange[]{lower, lower};
        }
        KeyRange higher = this.ranges.higher(searchKey);
        if (higher != null && higher.contains(key)) {
            this.lastContainingKeyRange = higher;
            return new KeyRange[]{higher, higher};
        }
        return new KeyRange[]{lower, higher};
    }

    public void add(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        assert (this.checkMinimal());
        if (range.isEmpty()) {
            return;
        }
        if (this.ranges.isEmpty()) {
            this.ranges.add(range);
            assert (this.checkMinimal());
            return;
        }
        KeyRange searchKey = new KeyRange(range.min, range.min);
        assert (!this.ranges.contains(searchKey));
        KeyRange prev = this.ranges.lower(searchKey);
        if (prev != null && KeyRange.compare(prev.max, range.min) >= 0) {
            if (KeyRange.compare(prev.max, range.max) >= 0) {
                assert (this.checkMinimal());
                return;
            }
            this.ranges.remove(prev);
            range = new KeyRange(prev.min, range.max);
        }
        Iterator<KeyRange> i = this.ranges.tailSet(searchKey, false).iterator();
        while (i.hasNext()) {
            KeyRange next = i.next();
            if (KeyRange.compare(next.min, range.max) > 0) break;
            i.remove();
            if (KeyRange.compare(next.max, range.max) <= 0) continue;
            range = new KeyRange(range.min, next.max);
            break;
        }
        this.ranges.add(range);
        assert (this.checkMinimal());
    }

    public void remove(KeyRange range) {
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"null range");
        assert (this.checkMinimal());
        if (range.isEmpty() || this.ranges.isEmpty()) {
            return;
        }
        KeyRange searchKey = new KeyRange(range.min, range.min);
        assert (!this.ranges.contains(searchKey));
        KeyRange prev = this.ranges.lower(searchKey);
        if (prev != null && prev.contains(range.min)) {
            this.ranges.remove(prev);
            if (KeyRange.compare(prev.min, range.min) < 0) {
                this.ranges.add(new KeyRange(prev.min, range.min));
            }
            if (KeyRange.compare(prev.max, range.max) > 0) {
                this.ranges.add(new KeyRange(range.max, prev.max));
                assert (this.checkMinimal());
                return;
            }
        }
        Iterator<KeyRange> i = this.ranges.tailSet(searchKey, false).iterator();
        while (i.hasNext()) {
            KeyRange next = i.next();
            if (KeyRange.compare(next.min, range.max) >= 0) break;
            i.remove();
            if (KeyRange.compare(next.max, range.max) <= 0) continue;
            this.ranges.add(new KeyRange(range.max, next.max));
            break;
        }
        assert (this.checkMinimal());
    }

    public void intersect(KeyRange range) {
        this.intersect(new KeyRanges(range));
    }

    public void add(KeyRanges ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        assert (this.checkMinimal());
        ranges.ranges.forEach(this::add);
    }

    public void remove(KeyRanges ranges) {
        Preconditions.checkArgument((ranges != null ? 1 : 0) != 0, (Object)"null ranges");
        assert (this.checkMinimal());
        if (this.ranges.isEmpty()) {
            return;
        }
        ranges.ranges.forEach(this::remove);
    }

    public void intersect(KeyRanges ranges) {
        this.remove(ranges.inverse());
    }

    @Override
    public Iterator<KeyRange> iterator() {
        return this.asSet().iterator();
    }

    public void serialize(OutputStream out) throws IOException {
        assert (this.checkMinimal());
        UnsignedIntEncoder.write((OutputStream)out, (int)this.ranges.size());
        byte[] prev = null;
        for (KeyRange range : this.ranges) {
            byte[] min = range.min;
            byte[] max = range.max;
            assert (max != null || range == this.ranges.last());
            KeyListEncoder.write(out, min, prev);
            KeyListEncoder.write(out, max != null ? max : min, min);
            prev = max;
        }
    }

    public long serializedLength() {
        long total = UnsignedIntEncoder.encodeLength((int)this.ranges.size());
        byte[] prev = null;
        for (KeyRange range : this.ranges) {
            byte[] min = range.min;
            byte[] max = range.max;
            total += (long)KeyListEncoder.writeLength(min, prev);
            total += (long)KeyListEncoder.writeLength(max != null ? max : min, min);
            prev = max;
        }
        return total;
    }

    public static Iterator<KeyRange> deserializeIterator(final InputStream input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        return new UnmodifiableIterator<KeyRange>(){
            private int remain = -1;
            private byte[] prev;

            public boolean hasNext() {
                try {
                    this.init();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.remain > 0;
            }

            public KeyRange next() {
                byte[] max;
                byte[] min;
                if (this.remain == 0) {
                    throw new NoSuchElementException();
                }
                try {
                    this.init();
                    min = KeyListEncoder.read(input, this.prev);
                    max = KeyListEncoder.read(input, min);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                KeyRange range = new KeyRange(min, Arrays.equals(min, max) ? null : max);
                this.prev = max;
                --this.remain;
                return range;
            }

            private void init() throws IOException {
                if (this.remain == -1) {
                    this.remain = UnsignedIntEncoder.read((InputStream)input);
                }
            }
        };
    }

    @Override
    public boolean contains(byte[] key) {
        assert (this.checkMinimal());
        KeyRange[] neighbors = this.findKey(key);
        return neighbors[0] == neighbors[1] && neighbors[0] != null;
    }

    @Override
    public byte[] seekHigher(byte[] key) {
        assert (this.checkMinimal());
        KeyRange[] neighbors = this.findKey(key);
        if (neighbors[0] == neighbors[1]) {
            return (byte[])(neighbors[0] != null ? key : null);
        }
        return neighbors[1] != null ? neighbors[1].getMin() : null;
    }

    @Override
    public byte[] seekLower(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        assert (this.checkMinimal());
        if (key.length == 0) {
            if (this.ranges.isEmpty()) {
                return null;
            }
            byte[] lastMax = ((KeyRange)this.ranges.last()).getMax();
            return lastMax != null ? lastMax : ByteUtil.EMPTY;
        }
        KeyRange[] neighbors = this.findKey(key);
        if (neighbors[0] == neighbors[1]) {
            return (byte[])(neighbors[0] != null ? key : null);
        }
        return neighbors[0] != null ? neighbors[0].getMax() : null;
    }

    public KeyRanges clone() {
        KeyRanges clone;
        assert (this.checkMinimal());
        try {
            clone = (KeyRanges)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.ranges = new TreeSet<KeyRange>((SortedSet<KeyRange>)clone.ranges);
        assert (clone.checkMinimal());
        return clone;
    }

    public KeyRanges immutableSnapshot() {
        KeyRanges clone;
        if (this.ranges instanceof ImmutableNavigableSet) {
            return this;
        }
        try {
            clone = (KeyRanges)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.ranges = new ImmutableNavigableSet(clone.ranges);
        assert (clone.checkMinimal());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KeyRanges that = (KeyRanges)obj;
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int index = 0;
        block4: for (KeyRange range : this.ranges) {
            switch (index++) {
                case 0: {
                    break;
                }
                case 32: {
                    buf.append("...");
                    break block4;
                }
                default: {
                    buf.append(",");
                }
            }
            buf.append(range);
        }
        buf.append(']');
        return buf.toString();
    }

    private boolean checkMinimal() {
        KeyRange prev = null;
        for (KeyRange range : this.ranges) {
            assert (!range.isEmpty()) : "contains empty range: " + range;
            assert (prev == null || KeyRange.compare(prev.max, range.min) < 0) : "touching ranges: " + prev + ", " + range;
            prev = range;
        }
        return true;
    }
}

