/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.LockOwner;
import org.jsimpledb.util.ByteUtil;

class Lock
extends KeyRange {
    public static final Comparator<Lock> MIN_COMPARATOR = Comparator.comparing(KeyRange::getMin, KeyRange::compare).thenComparing(Lock::isWrite, Boolean::compare);
    public static final Comparator<Lock> MAX_COMPARATOR = Comparator.comparing(KeyRange::getMax, KeyRange::compare).thenComparing(Lock::isWrite, Boolean::compare);
    private static final LockOwner DUMMY_OWNER = new LockOwner();
    final boolean write;
    final LockOwner owner;

    Lock(LockOwner owner, byte[] min, byte[] max, boolean write) {
        super(min, max);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"null owner");
        this.owner = owner;
        this.write = write;
    }

    public LockOwner getOwner() {
        return this.owner;
    }

    public boolean isWrite() {
        return this.write;
    }

    public boolean conflictsWith(Lock that) {
        return this.overlaps(that) && (this.write || that.write) && !this.owner.equals(that.owner);
    }

    public Lock mergeWith(Lock that) {
        if (!this.owner.equals(that.owner)) {
            return null;
        }
        if (KeyRange.compare(this.min, that.max) > 0 || KeyRange.compare(that.min, this.max) > 0) {
            return null;
        }
        if (this.write != that.write && !(!this.write ? that.contains(this) : this.contains(that))) {
            return null;
        }
        byte[] newMin = KeyRange.compare(this.min, that.min) < 0 ? this.min : that.min;
        byte[] newMax = KeyRange.compare(this.max, that.max) > 0 ? this.max : that.max;
        return new Lock(this.owner, newMin, newMax, this.write || that.write);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Lock that = (Lock)obj;
        return this.owner.equals(that.owner) && this.write == that.write;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.owner.hashCode() ^ (this.write ? 1 : 0);
    }

    @Override
    public String toString() {
        return "Lock[owner=" + this.owner + ",min=" + ByteUtil.toString((byte[])this.min) + ",max=" + ByteUtil.toString((byte[])this.max) + ",type=" + (this.write ? "write" : "read") + "]";
    }

    public static Lock getMinKey(byte[] min, boolean write) {
        Preconditions.checkArgument((min != null ? 1 : 0) != 0, (Object)"null min");
        return new Lock(DUMMY_OWNER, min, min, write);
    }

    public static Lock getMaxKey(byte[] max, boolean write) {
        Preconditions.checkArgument((max != null ? 1 : 0) != 0, (Object)"null max");
        return new Lock(DUMMY_OWNER, max, max, write);
    }
}

