/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.util.ByteUtil;

public class Reads
extends KeyRanges {
    public Reads() {
        super(new KeyRange[0]);
    }

    public Reads(KeyRanges ranges) {
        super(ranges);
    }

    public Reads(InputStream input) throws IOException {
        super(input);
    }

    public boolean isConflict(Mutations mutations) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        for (KeyRange keyRange : mutations.getRemoveRanges()) {
            if (!this.intersects(keyRange)) continue;
            return true;
        }
        for (Map.Entry entry : mutations.getPutPairs()) {
            if (!this.contains((byte[])entry.getKey())) continue;
            return true;
        }
        for (Map.Entry entry : mutations.getAdjustPairs()) {
            if (!this.contains((byte[])entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public List<String> getConflicts(Mutations mutations) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        ArrayList<String> conflicts = new ArrayList<String>();
        for (KeyRange keyRange : mutations.getRemoveRanges()) {
            if (!this.intersects(keyRange)) continue;
            KeyRanges intersection = new KeyRanges(keyRange);
            intersection.intersect(this);
            StringBuilder buf = new StringBuilder();
            for (KeyRange range : intersection) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(range.isSingleKey() ? ByteUtil.toString((byte[])range.getMin()) : range);
            }
            conflicts.add("read/remove conflict: " + buf);
        }
        for (Map.Entry entry : mutations.getPutPairs()) {
            if (!this.contains((byte[])entry.getKey())) continue;
            conflicts.add("read/write conflict: " + ByteUtil.toString((byte[])((byte[])entry.getKey())));
        }
        for (Map.Entry entry : mutations.getAdjustPairs()) {
            if (!this.contains((byte[])entry.getKey())) continue;
            conflicts.add("read/adjust conflict: " + ByteUtil.toString((byte[])((byte[])entry.getKey())));
        }
        return conflicts;
    }

    @Override
    public Reads clone() {
        return (Reads)super.clone();
    }

    @Override
    public Reads immutableSnapshot() {
        return (Reads)super.immutableSnapshot();
    }
}

