/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.SnapshotKVTransaction;
import org.jsimpledb.kv.mvcc.SnapshotRefs;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.util.CloseableForwardingKVStore;
import org.jsimpledb.kv.util.KeyWatchTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class SnapshotKVDatabase
implements KVDatabase {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @GuardedBy(value="this")
    private final HashSet<SnapshotKVTransaction> transactions = new HashSet();
    @GuardedBy(value="this")
    private SnapshotRefs snapshot;
    @GuardedBy(value="this")
    private AtomicKVStore kvstore;
    @GuardedBy(value="this")
    private KeyWatchTracker keyWatchTracker;
    @GuardedBy(value="this")
    private long currentVersion;
    @GuardedBy(value="this")
    private boolean started;
    @GuardedBy(value="this")
    private boolean stopping;

    public SnapshotKVDatabase() {
    }

    public SnapshotKVDatabase(AtomicKVStore kvstore) {
        this.kvstore = kvstore;
    }

    protected synchronized AtomicKVStore getKVStore() {
        return this.kvstore;
    }

    protected synchronized void setKVStore(AtomicKVStore kvstore) {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.kvstore = kvstore;
    }

    public synchronized long getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    @PostConstruct
    public synchronized void start() {
        if (this.started) {
            return;
        }
        Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"no KVStore configured");
        this.kvstore.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void stop() {
        SnapshotKVDatabase snapshotKVDatabase = this;
        synchronized (snapshotKVDatabase) {
            if (!this.started || this.stopping) {
                return;
            }
            this.log.info("stopping " + this);
            this.stopping = true;
        }
        this.closeTransactions();
        snapshotKVDatabase = this;
        synchronized (snapshotKVDatabase) {
            assert (this.started);
            if (this.snapshot != null) {
                this.snapshot.unref();
                this.snapshot = null;
            }
            this.kvstore.stop();
            if (this.keyWatchTracker != null) {
                this.keyWatchTracker.close();
                this.keyWatchTracker = null;
            }
            this.stopping = false;
            this.started = false;
        }
    }

    @Override
    public SnapshotKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction();
    }

    @Override
    public synchronized SnapshotKVTransaction createTransaction() {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        Preconditions.checkState((!this.stopping ? 1 : 0) != 0, (Object)"stopping");
        MutableView view = new MutableView(this.getCurrentSnapshot().getKVStore());
        SnapshotKVTransaction tx = this.createSnapshotKVTransaction(view, this.currentVersion);
        assert (!this.transactions.contains(tx));
        this.transactions.add(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace("created new transaction " + tx + " (new total " + this.transactions.size() + ")");
        }
        return tx;
    }

    synchronized ListenableFuture<Void> watchKey(byte[] key) {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        if (this.keyWatchTracker == null) {
            this.keyWatchTracker = new KeyWatchTracker();
        }
        return this.keyWatchTracker.register(key);
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[kvstore=" + this.kvstore + ",started=" + this.started + ",currentVersion=" + this.currentVersion + "]";
    }

    protected SnapshotKVTransaction createSnapshotKVTransaction(MutableView view, long baseVersion) {
        return new SnapshotKVTransaction(this, view, baseVersion);
    }

    protected synchronized void closeTransactions() {
        for (SnapshotKVTransaction tx : new ArrayList<SnapshotKVTransaction>(this.transactions)) {
            if (tx.error == null) {
                tx.error = new KVTransactionException((KVTransaction)tx, "database was stopped");
            }
            this.cleanupTransaction(tx);
        }
    }

    protected KVTransactionException logException(KVTransactionException e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("throwing exception for " + e.getTransaction() + ": " + e);
        }
        return e;
    }

    protected RuntimeException wrapException(SnapshotKVTransaction tx, RuntimeException e) {
        return e;
    }

    synchronized void commit(SnapshotKVTransaction tx, boolean readOnly) {
        assert (Thread.holdsLock(tx));
        try {
            this.doCommit(tx, readOnly);
        }
        finally {
            tx.error = null;
            this.cleanupTransaction(tx);
        }
    }

    synchronized void rollback(SnapshotKVTransaction tx) {
        assert (Thread.holdsLock(tx));
        if (this.log.isTraceEnabled()) {
            this.log.trace("rolling back transaction " + tx);
        }
        tx.error = null;
        this.cleanupTransaction(tx);
    }

    synchronized CloseableKVStore createMutableSnapshot(Writes writes) {
        SnapshotRefs snapshotRefs = this.getCurrentSnapshot();
        snapshotRefs.ref();
        MutableView view = new MutableView(snapshotRefs.getKVStore(), null, writes);
        return new CloseableForwardingKVStore(view, snapshotRefs.getUnrefCloseable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doCommit(SnapshotKVTransaction tx, boolean readOnly) {
        Writes txWrites;
        assert (Thread.holdsLock(tx));
        assert (Thread.holdsLock(this));
        if (this.log.isTraceEnabled()) {
            this.log.trace("committing transaction " + tx + " based on version " + tx.baseVersion + " (current version is " + this.currentVersion + ")");
        }
        if (!this.transactions.remove(tx)) {
            tx.throwErrorIfAny();
            throw this.logException(new StaleTransactionException(tx));
        }
        assert (tx.error == null);
        assert (this.snapshot != null);
        MutableView mutableView = tx.view;
        synchronized (mutableView) {
            txWrites = tx.getMutableView().getWrites();
            tx.view.disableReadTracking();
            tx.view.setReadOnly();
        }
        if (readOnly || txWrites.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no mutations in " + tx + ", staying at version " + this.currentVersion);
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("applying " + tx + " mutations and advancing version from " + this.currentVersion + " -> " + (this.currentVersion + 1L));
        }
        this.kvstore.mutate(txWrites, true);
        SnapshotRefs oldSnapshot = this.snapshot;
        this.snapshot = null;
        ++this.currentVersion;
        int numTx = this.transactions.size();
        Iterator<SnapshotKVTransaction> i = this.transactions.iterator();
        while (i.hasNext()) {
            SnapshotKVTransaction victim = i.next();
            assert (victim.error == null);
            MutableView mutableView2 = victim.view;
            synchronized (mutableView2) {
                boolean conflict = victim.view.getReads().isConflict(txWrites);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("ordering " + victim + " after " + tx + " writes in version " + this.currentVersion + " results in " + (conflict ? "" : "no ") + "conflict");
                }
                if (conflict) {
                    i.remove();
                    victim.error = new RetryTransactionException((KVTransaction)victim, "transaction is based on version " + victim.baseVersion + " but the transaction committed at version " + this.currentVersion + " contains conflicting writes");
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("removed conflicting transaction " + victim + " (new total " + --numTx + ")");
                    }
                    victim.view.setKVStore(victim);
                    continue;
                }
                victim.view.setKVStore(this.getCurrentSnapshot().getKVStore());
            }
        }
        oldSnapshot.unref();
        if (this.keyWatchTracker != null) {
            this.keyWatchTracker.trigger(txWrites);
        }
    }

    private void cleanupTransaction(SnapshotKVTransaction tx) {
        assert (Thread.holdsLock(this));
        if (this.log.isTraceEnabled()) {
            this.log.trace("cleaning up transaction " + tx);
        }
        if (this.transactions.remove(tx) && this.log.isTraceEnabled()) {
            this.log.trace("removed transaction " + tx + " (new total " + this.transactions.size() + ")");
        }
    }

    private SnapshotRefs getCurrentSnapshot() {
        assert (Thread.holdsLock(this));
        if (this.snapshot == null) {
            this.snapshot = new SnapshotRefs(this.kvstore.snapshot());
            if (this.log.isTraceEnabled()) {
                this.log.trace("created new snapshot for version " + this.currentVersion);
            }
        }
        return this.snapshot;
    }
}

