/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.TransactionTimeoutException;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.SnapshotKVDatabase;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SnapshotKVTransaction
extends ForwardingKVStore
implements KVTransaction,
Closeable {
    private static final AtomicLong COUNTER = new AtomicLong();
    final long uniqueId = COUNTER.incrementAndGet();
    final long startTime;
    final SnapshotKVDatabase kvdb;
    final MutableView view;
    final long baseVersion;
    @GuardedBy(value="kvdb")
    volatile KVTransactionException error;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean closed = new AtomicBoolean();
    @GuardedBy(value="this")
    private boolean readOnly;
    @GuardedBy(value="this")
    private long timeout;

    protected SnapshotKVTransaction(SnapshotKVDatabase kvdb, MutableView view, long baseVersion) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0);
        Preconditions.checkArgument((view != null ? 1 : 0) != 0);
        this.kvdb = kvdb;
        this.view = view;
        this.baseVersion = baseVersion;
        this.startTime = System.nanoTime();
    }

    public long getBaseVersion() {
        return this.baseVersion;
    }

    public MutableView getMutableView() {
        return this.view;
    }

    @Override
    protected synchronized KVStore delegate() {
        this.checkAlive();
        return this.view;
    }

    @Override
    public SnapshotKVDatabase getKVDatabase() {
        return this.kvdb;
    }

    @Override
    public synchronized void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        this.timeout = timeout;
    }

    public synchronized ListenableFuture<Void> watchKey(byte[] key) {
        this.checkAlive();
        return this.kvdb.watchKey(key);
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public synchronized void commit() {
        this.checkAlive();
        this.closed.set(true);
        this.kvdb.commit(this, this.readOnly);
    }

    @Override
    public synchronized void rollback() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.kvdb.rollback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableKVStore mutableSnapshot() {
        Writes writes;
        SnapshotKVTransaction snapshotKVTransaction = this;
        synchronized (snapshotKVTransaction) {
            this.checkAlive();
            MutableView mutableView = this.view;
            synchronized (mutableView) {
                writes = this.view.getWrites().clone();
            }
        }
        return this.kvdb.createMutableSnapshot(writes);
    }

    @Override
    public void close() {
        this.rollback();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.uniqueId + ",vers=" + this.baseVersion + (this.closed.get() ? ",closed" : "") + "]";
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed.get()) {
                this.log.warn(this + " leaked without commit() or rollback()");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    void throwErrorIfAny() {
        assert (Thread.holdsLock(this.kvdb));
        if (this.error != null) {
            throw this.kvdb.logException(this.error.duplicate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAlive() {
        long duration;
        assert (Thread.holdsLock(this));
        if (this.closed.get()) {
            throw this.kvdb.logException(new StaleTransactionException(this));
        }
        if (this.error == null && this.timeout != 0L && (duration = (System.nanoTime() - this.startTime) / 1000000L) >= this.timeout) {
            SnapshotKVDatabase snapshotKVDatabase = this.kvdb;
            synchronized (snapshotKVDatabase) {
                if (this.error == null) {
                    this.error = new TransactionTimeoutException((KVTransaction)this, "transaction has timed out after " + duration + "ms > limit of " + this.timeout + "ms");
                }
            }
        }
        if (this.error != null) {
            SnapshotKVDatabase snapshotKVDatabase = this.kvdb;
            synchronized (snapshotKVDatabase) {
                this.throwErrorIfAny();
            }
        }
    }
}

