/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SnapshotRefs {
    private final CloseableKVStore snapshot;
    private final AtomicInteger refs = new AtomicInteger(1);

    public SnapshotRefs(CloseableKVStore snapshot) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"null snapshot");
        this.snapshot = snapshot;
    }

    public KVStore getKVStore() {
        Preconditions.checkState((this.refs.get() > 0 ? 1 : 0) != 0, (Object)"no longer referenced");
        return this.snapshot;
    }

    public void ref() {
        Preconditions.checkState((this.refs.get() > 0 ? 1 : 0) != 0, (Object)"no longer referenced");
        this.refs.incrementAndGet();
    }

    public void unref() {
        Preconditions.checkState((this.refs.get() > 0 ? 1 : 0) != 0, (Object)"no longer referenced");
        if (this.refs.decrementAndGet() == 0) {
            this.snapshot.close();
        }
    }

    public int refs() {
        return this.refs.get();
    }

    public Closeable getUnrefCloseable() {
        return new Closeable(){
            private boolean closed;

            @Override
            public synchronized void close() {
                if (this.closed) {
                    return;
                }
                SnapshotRefs.this.unref();
                this.closed = true;
            }
        };
    }

    protected void finalize() throws Throwable {
        try {
            int remaining = this.refs.get();
            if (remaining > 0) {
                LoggerFactory.getLogger(this.getClass()).warn(this + " leaked with " + remaining + " remaining reference(s)");
                this.refs.set(0);
                this.snapshot.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

