/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mvcc;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.util.KeyListEncoder;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ConvertedNavigableMap;
import org.jsimpledb.util.ImmutableNavigableMap;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.UnsignedIntEncoder;

public class Writes
implements Cloneable,
Mutations {
    private KeyRanges removes;
    private NavigableMap<byte[], byte[]> puts;
    private NavigableMap<byte[], Long> adjusts;
    private boolean immutable;

    public Writes() {
        this(KeyRanges.empty(), new TreeMap<byte[], byte[]>(ByteUtil.COMPARATOR), new TreeMap<byte[], Long>(ByteUtil.COMPARATOR), false);
    }

    private Writes(KeyRanges removes, NavigableMap<byte[], byte[]> puts, NavigableMap<byte[], Long> adjusts, boolean immutable) {
        this.removes = removes;
        this.puts = puts;
        this.adjusts = adjusts;
        this.immutable = immutable;
    }

    public KeyRanges getRemoves() {
        return this.removes;
    }

    public NavigableMap<byte[], byte[]> getPuts() {
        return this.puts;
    }

    public NavigableMap<byte[], Long> getAdjusts() {
        return this.adjusts;
    }

    public boolean isEmpty() {
        return this.removes.isEmpty() && this.puts.isEmpty() && this.adjusts.isEmpty();
    }

    public void clear() {
        this.removes.clear();
        this.puts.clear();
        this.adjusts.clear();
    }

    public NavigableSet<KeyRange> getRemoveRanges() {
        return this.removes.asSet();
    }

    public Iterable<Map.Entry<byte[], byte[]>> getPutPairs() {
        return this.getPuts().entrySet();
    }

    public Iterable<Map.Entry<byte[], Long>> getAdjustPairs() {
        return this.getAdjusts().entrySet();
    }

    public void applyTo(KVStore target) {
        Writes.apply(this, target);
    }

    public static void apply(Mutations mutations, KVStore target) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        for (KeyRange keyRange : mutations.getRemoveRanges()) {
            target.removeRange(keyRange.getMin(), keyRange.getMax());
        }
        for (Map.Entry entry : mutations.getPutPairs()) {
            target.put((byte[])entry.getKey(), (byte[])entry.getValue());
        }
        for (Map.Entry entry : mutations.getAdjustPairs()) {
            target.adjustCounter((byte[])entry.getKey(), (Long)entry.getValue());
        }
    }

    public void serialize(OutputStream out) throws IOException {
        byte[] key;
        this.removes.serialize(out);
        UnsignedIntEncoder.write((OutputStream)out, (int)this.puts.size());
        byte[] prev = null;
        for (Map.Entry entry : this.puts.entrySet()) {
            key = (byte[])entry.getKey();
            byte[] value = (byte[])entry.getValue();
            KeyListEncoder.write(out, key, prev);
            KeyListEncoder.write(out, value, null);
            prev = key;
        }
        UnsignedIntEncoder.write((OutputStream)out, (int)this.adjusts.size());
        prev = null;
        for (Map.Entry entry : this.adjusts.entrySet()) {
            key = (byte[])entry.getKey();
            long value = (Long)entry.getValue();
            KeyListEncoder.write(out, key, prev);
            LongEncoder.write((OutputStream)out, (long)value);
            prev = key;
        }
    }

    public long serializedLength() {
        byte[] key;
        long total = this.removes.serializedLength();
        total += (long)UnsignedIntEncoder.encodeLength((int)this.puts.size());
        byte[] prev = null;
        for (Map.Entry entry : this.puts.entrySet()) {
            key = (byte[])entry.getKey();
            byte[] value = (byte[])entry.getValue();
            total += (long)KeyListEncoder.writeLength(key, prev);
            total += (long)KeyListEncoder.writeLength(value, null);
            prev = key;
        }
        total += (long)UnsignedIntEncoder.encodeLength((int)this.adjusts.size());
        prev = null;
        for (Map.Entry entry : this.adjusts.entrySet()) {
            key = (byte[])entry.getKey();
            long value = (Long)entry.getValue();
            total += (long)KeyListEncoder.writeLength(key, prev);
            total += (long)LongEncoder.encodeLength((long)value);
            prev = key;
        }
        return total;
    }

    public static Writes deserialize(InputStream input) throws IOException {
        return Writes.deserialize(input, false);
    }

    public static Writes deserialize(InputStream input, boolean immutable) throws IOException {
        ImmutableNavigableMap adjusts;
        ImmutableNavigableMap puts;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        KeyRanges removes = new KeyRanges(input, immutable);
        int putCount = UnsignedIntEncoder.read((InputStream)input);
        byte[][] putKeys = new byte[putCount][];
        byte[][] putVals = new byte[putCount][];
        byte[] prev = null;
        for (int i = 0; i < putCount; ++i) {
            putKeys[i] = KeyListEncoder.read(input, prev);
            putVals[i] = KeyListEncoder.read(input, null);
            prev = putKeys[i];
        }
        if (immutable) {
            puts = new ImmutableNavigableMap((Object[])putKeys, (Object[])putVals, ByteUtil.COMPARATOR);
        } else {
            puts = new TreeMap(ByteUtil.COMPARATOR);
            for (int i = 0; i < putCount; ++i) {
                puts.put(putKeys[i], putVals[i]);
            }
        }
        int adjCount = UnsignedIntEncoder.read((InputStream)input);
        byte[][] adjKeys = new byte[adjCount][];
        Object[] adjVals = new Long[adjCount];
        prev = null;
        for (int i = 0; i < adjCount; ++i) {
            adjKeys[i] = KeyListEncoder.read(input, prev);
            adjVals[i] = LongEncoder.read((InputStream)input);
            prev = adjKeys[i];
        }
        if (immutable) {
            adjusts = new ImmutableNavigableMap((Object[])adjKeys, adjVals, ByteUtil.COMPARATOR);
        } else {
            adjusts = new TreeMap(ByteUtil.COMPARATOR);
            for (int i = 0; i < adjCount; ++i) {
                adjusts.put(adjKeys[i], adjVals[i]);
            }
        }
        return new Writes(removes, (NavigableMap<byte[], byte[]>)puts, (NavigableMap<byte[], Long>)adjusts, immutable);
    }

    public Writes clone() {
        Writes clone;
        try {
            clone = (Writes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.removes = this.removes.clone();
        clone.puts = new TreeMap<byte[], byte[]>((SortedMap<byte[], byte[]>)clone.puts);
        clone.adjusts = new TreeMap<byte[], Long>((SortedMap<byte[], Long>)clone.adjusts);
        clone.immutable = false;
        return clone;
    }

    public Writes immutableSnapshot() {
        if (this.immutable) {
            return this;
        }
        return new Writes(this.removes.immutableSnapshot(), (NavigableMap<byte[], byte[]>)new ImmutableNavigableMap(this.puts), (NavigableMap<byte[], Long>)new ImmutableNavigableMap(this.adjusts), true);
    }

    public String toString() {
        Converter byteConverter = ByteUtil.STRING_CONVERTER.reverse();
        ConvertedNavigableMap putsView = new ConvertedNavigableMap(this.puts, byteConverter, byteConverter);
        ConvertedNavigableMap adjustsView = new ConvertedNavigableMap(this.adjusts, byteConverter, Converter.identity());
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[removes=").append(this.removes);
        if (!this.puts.isEmpty()) {
            buf.append(",puts=");
            this.appendEntries(buf, (Map<String, ?>)putsView);
        }
        if (!this.adjusts.isEmpty()) {
            buf.append(",adjusts=");
            this.appendEntries(buf, (Map<String, ?>)adjustsView);
        }
        buf.append("]");
        return buf.toString();
    }

    private void appendEntries(StringBuilder buf, Map<String, ?> map) {
        buf.append('{');
        int index = 0;
        block4: for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            switch (index++) {
                case 0: {
                    break;
                }
                case 32: {
                    buf.append("...");
                    break block4;
                }
                default: {
                    buf.append(", ");
                }
            }
            buf.append(this.truncate(key, 32)).append('=').append(this.truncate(String.valueOf(val), 32));
        }
    }

    private String truncate(String s, int max) {
        if (s == null || s.length() <= max) {
            return s;
        }
        return s.substring(0, max) + "...";
    }
}

