/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.LoggerFactory;

public abstract class AbstractKVIterator<E>
implements CloseableIterator<E> {
    protected final KVStore kv;
    protected final boolean prefixMode;
    protected final boolean reversed;
    private final CloseableIterator<KVPair> pairIterator;
    private KVPair removePair;
    private E removeValue;

    protected AbstractKVIterator(KVStore kv, boolean prefixMode, boolean reversed) {
        this(kv, prefixMode, reversed, null, null);
    }

    protected AbstractKVIterator(KVStore kv, boolean prefixMode, boolean reversed, byte[] prefix) {
        this(kv, prefixMode, reversed, KeyRange.forPrefix(prefix), null);
    }

    protected AbstractKVIterator(KVStore kv, boolean prefixMode, boolean reversed, KeyRange keyRange, KeyFilter keyFilter) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
        this.prefixMode = prefixMode;
        this.reversed = reversed;
        if (!this.prefixMode && keyFilter == null) {
            byte[] minKey = keyRange != null ? keyRange.getMin() : null;
            byte[] maxKey = keyRange != null ? keyRange.getMax() : null;
            this.pairIterator = this.kv.getRange(minKey, maxKey, this.reversed);
        } else {
            this.pairIterator = new KVPairIterator(this.kv, keyRange, keyFilter, this.reversed);
        }
    }

    public boolean hasNext() {
        return this.pairIterator.hasNext();
    }

    public synchronized E next() {
        KVPair pair = (KVPair)this.pairIterator.next();
        ByteReader keyReader = new ByteReader(pair.getKey());
        E value = this.decodePair(pair, keyReader);
        if (!this.prefixMode && keyReader.remain() > 0) {
            String msg = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ": " + keyReader.remain() + " undecoded bytes remain in key " + ByteUtil.toString((byte[])pair.getKey()) + ", value " + ByteUtil.toString((byte[])pair.getValue()) + " -> " + value;
            LoggerFactory.getLogger(this.getClass()).error(msg);
            assert (false) : msg;
        }
        if (this.prefixMode) {
            KVPairIterator kvPairIterator = (KVPairIterator)this.pairIterator;
            byte[] prefix = keyReader.getBytes(0, keyReader.getOffset());
            kvPairIterator.setNextTarget(this.reversed ? prefix : ByteUtil.getKeyAfterPrefix((byte[])prefix));
        }
        this.removePair = pair;
        this.removeValue = value;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        E removeValueCopy;
        KVPair removePairCopy;
        AbstractKVIterator abstractKVIterator = this;
        synchronized (abstractKVIterator) {
            removePairCopy = this.removePair;
            if (removePairCopy == null) {
                throw new IllegalStateException();
            }
            this.removePair = null;
            removeValueCopy = this.removeValue;
        }
        this.doRemove(removeValueCopy, removePairCopy);
    }

    public void close() {
        this.pairIterator.close();
    }

    protected abstract E decodePair(KVPair var1, ByteReader var2);

    protected void doRemove(E value, KVPair pair) {
        throw new UnsupportedOperationException();
    }
}

