/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyFilterUtil;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.AbstractKVIterator;
import org.jsimpledb.kv.util.AbstractKVNavigableSet;
import org.jsimpledb.util.AbstractIterationSet;
import org.jsimpledb.util.AbstractNavigableMap;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public abstract class AbstractKVNavigableMap<K, V>
extends AbstractNavigableMap<K, V> {
    protected final KVStore kv;
    protected final boolean prefixMode;
    protected final boolean reversed;
    protected final KeyRange keyRange;
    protected final KeyFilter keyFilter;

    protected AbstractKVNavigableMap(KVStore kv, boolean prefixMode) {
        this(kv, prefixMode, (KeyRange)null);
    }

    protected AbstractKVNavigableMap(KVStore kv, boolean prefixMode, byte[] prefix) {
        this(kv, prefixMode, KeyRange.forPrefix(prefix));
    }

    protected AbstractKVNavigableMap(KVStore kv, boolean prefixMode, KeyRange keyRange) {
        this(kv, prefixMode, false, keyRange, null, new Bounds());
    }

    protected AbstractKVNavigableMap(KVStore kv, boolean prefixMode, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<K> bounds) {
        super(bounds);
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
        this.prefixMode = prefixMode;
        this.reversed = reversed;
        this.keyRange = keyRange;
        this.keyFilter = keyFilter;
    }

    public V get(Object obj) {
        KVPair pair;
        byte[] key = this.encodeVisibleKey(obj, false);
        if (key == null) {
            return null;
        }
        if (this.prefixMode) {
            byte[] maxKey;
            try {
                maxKey = ByteUtil.getKeyAfterPrefix((byte[])key);
            }
            catch (IllegalArgumentException e) {
                maxKey = null;
            }
            pair = this.kv.getAtLeast(key, maxKey);
            if (pair == null) {
                return null;
            }
            assert (ByteUtil.isPrefixOf((byte[])key, (byte[])pair.getKey()));
        } else {
            byte[] value = this.kv.get(key);
            if (value == null) {
                return null;
            }
            pair = new KVPair(key, value);
        }
        return this.decodeValue(pair);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public NavigableSet<K> navigableKeySet() {
        return new KeySet();
    }

    public NavigableMap<K, V> filterKeys(KeyFilter keyFilter) {
        Preconditions.checkArgument((keyFilter != null ? 1 : 0) != 0, (Object)"null keyFilter");
        if (this.keyFilter != null) {
            keyFilter = KeyFilterUtil.intersection(keyFilter, this.keyFilter);
        }
        return this.createSubMap(this.reversed, this.keyRange, keyFilter, this.bounds);
    }

    protected boolean isWithinLowerBound(K key) {
        if (!super.isWithinLowerBound(key)) {
            return false;
        }
        if (this.keyRange == null) {
            return true;
        }
        ByteWriter writer = new ByteWriter();
        this.encodeKey(writer, key);
        return KeyRange.compare(writer.getBytes(), this.keyRange.getMin()) >= 0;
    }

    protected boolean isWithinUpperBound(K key) {
        if (!super.isWithinUpperBound(key)) {
            return false;
        }
        if (this.keyRange == null) {
            return true;
        }
        ByteWriter writer = new ByteWriter();
        this.encodeKey(writer, key);
        return KeyRange.compare(writer.getBytes(), this.keyRange.getMax()) < 0;
    }

    protected final NavigableMap<K, V> createSubMap(boolean reverse, Bounds<K> newBounds) {
        boolean newReversed = this.reversed ^ reverse;
        KeyRange newKeyRange = this.buildKeyRange(newReversed ? newBounds.reverse() : newBounds);
        return this.createSubMap(newReversed, newKeyRange, this.keyFilter, newBounds);
    }

    protected abstract NavigableMap<K, V> createSubMap(boolean var1, KeyRange var2, KeyFilter var3, Bounds<K> var4);

    protected abstract void encodeKey(ByteWriter var1, Object var2);

    protected abstract K decodeKey(ByteReader var1);

    protected abstract V decodeValue(KVPair var1);

    protected boolean isVisible(byte[] key) {
        return !(this.keyRange != null && !this.keyRange.contains(key) || this.keyFilter != null && !this.keyFilter.contains(key));
    }

    protected byte[] encodeVisibleKey(Object obj, boolean fail) {
        ByteWriter writer = new ByteWriter();
        try {
            this.encodeKey(writer, obj);
        }
        catch (IllegalArgumentException e) {
            if (!fail) {
                return null;
            }
            throw e;
        }
        byte[] key = writer.getBytes();
        if (this.keyRange != null && !this.keyRange.contains(key)) {
            if (fail) {
                throw new IllegalArgumentException("key is out of bounds: " + obj);
            }
            return null;
        }
        if (this.keyFilter != null && !this.keyFilter.contains(key)) {
            if (fail) {
                throw new IllegalArgumentException("key is filtered out: " + obj);
            }
            return null;
        }
        return key;
    }

    private KeyRange buildKeyRange(Bounds<K> bounds) {
        byte[] newMaxKey;
        ByteWriter writer;
        byte[] newMinKey;
        byte[] minKey = this.keyRange != null ? this.keyRange.getMin() : null;
        byte[] maxKey = this.keyRange != null ? this.keyRange.getMax() : null;
        switch (bounds.getLowerBoundType()) {
            case NONE: {
                newMinKey = minKey;
                break;
            }
            default: {
                writer = new ByteWriter();
                this.encodeKey(writer, bounds.getLowerBound());
                newMinKey = writer.getBytes();
                if (!bounds.getLowerBoundType().isInclusive().booleanValue()) {
                    byte[] byArray = newMinKey = this.prefixMode ? ByteUtil.getKeyAfterPrefix((byte[])newMinKey) : ByteUtil.getNextKey((byte[])newMinKey);
                }
                if (minKey != null) {
                    newMinKey = ByteUtil.max((byte[])newMinKey, (byte[])minKey);
                }
                if (maxKey == null) break;
                newMinKey = ByteUtil.min((byte[])newMinKey, (byte[])maxKey);
            }
        }
        switch (bounds.getUpperBoundType()) {
            case NONE: {
                newMaxKey = maxKey;
                break;
            }
            default: {
                writer = new ByteWriter();
                this.encodeKey(writer, bounds.getUpperBound());
                newMaxKey = writer.getBytes();
                if (bounds.getUpperBoundType().isInclusive().booleanValue()) {
                    byte[] byArray = newMaxKey = this.prefixMode ? ByteUtil.getKeyAfterPrefix((byte[])newMaxKey) : ByteUtil.getNextKey((byte[])newMaxKey);
                }
                if (maxKey != null) {
                    newMaxKey = ByteUtil.min((byte[])newMaxKey, (byte[])maxKey);
                }
                if (minKey == null) break;
                newMaxKey = ByteUtil.max((byte[])newMaxKey, (byte[])minKey);
            }
        }
        return new KeyRange(newMinKey != null ? newMinKey : ByteUtil.EMPTY, newMaxKey);
    }

    private class MapEntry
    extends AbstractMap.SimpleEntry<K, V> {
        MapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            AbstractKVNavigableMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }
    }

    private class EntrySet
    extends AbstractIterationSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        public Iterator<Map.Entry<K, V>> iterator() {
            return new AbstractKVIterator<Map.Entry<K, V>>(AbstractKVNavigableMap.this.kv, AbstractKVNavigableMap.this.prefixMode, AbstractKVNavigableMap.this.reversed, AbstractKVNavigableMap.this.keyRange, AbstractKVNavigableMap.this.keyFilter){

                @Override
                protected Map.Entry<K, V> decodePair(KVPair pair, ByteReader keyReader) {
                    Object key = AbstractKVNavigableMap.this.decodeKey(keyReader);
                    Object value = AbstractKVNavigableMap.this.decodeValue(pair);
                    return new MapEntry(key, value);
                }

                @Override
                protected void doRemove(Map.Entry<K, V> entry, KVPair pair) {
                    AbstractKVNavigableMap.this.entrySet().remove(entry);
                }
            };
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            if (!AbstractKVNavigableMap.this.containsKey(entry.getKey())) {
                return false;
            }
            Object key = entry.getKey();
            Object value = AbstractKVNavigableMap.this.get(entry.getKey());
            return new MapEntry(key, value).equals(entry);
        }

        public boolean remove(Object obj) {
            Object value;
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            if (!AbstractKVNavigableMap.this.containsKey(entry.getKey())) {
                return false;
            }
            Object key = entry.getKey();
            if (new MapEntry(key, value = AbstractKVNavigableMap.this.get(entry.getKey())).equals(entry)) {
                AbstractKVNavigableMap.this.remove(key);
                return true;
            }
            return false;
        }

        public void clear() {
            AbstractKVNavigableMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractKVNavigableSet<K> {
        KeySet() {
            super(AbstractKVNavigableMap.this.kv, AbstractKVNavigableMap.this.prefixMode, AbstractKVNavigableMap.this.reversed, AbstractKVNavigableMap.this.keyRange, AbstractKVNavigableMap.this.keyFilter, AbstractKVNavigableMap.this.bounds);
        }

        public Comparator<? super K> comparator() {
            return AbstractKVNavigableMap.this.comparator();
        }

        public boolean remove(Object obj) {
            boolean existed = AbstractKVNavigableMap.this.containsKey(obj);
            AbstractKVNavigableMap.this.remove(obj);
            return existed;
        }

        public void clear() {
            AbstractKVNavigableMap.this.clear();
        }

        @Override
        protected void encode(ByteWriter writer, Object obj) {
            AbstractKVNavigableMap.this.encodeKey(writer, obj);
        }

        @Override
        protected K decode(ByteReader reader) {
            return AbstractKVNavigableMap.this.decodeKey(reader);
        }

        @Override
        protected NavigableSet<K> createSubSet(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<K> newBounds) {
            return AbstractKVNavigableMap.this.createSubMap(newReversed, newKeyRange, newKeyFilter, newBounds).navigableKeySet();
        }
    }
}

