/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.util.NavigableSet;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyFilterUtil;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.AbstractKVIterator;
import org.jsimpledb.util.AbstractNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;

public abstract class AbstractKVNavigableSet<E>
extends AbstractNavigableSet<E> {
    protected final KVStore kv;
    protected final boolean prefixMode;
    protected final boolean reversed;
    protected final KeyRange keyRange;
    protected final KeyFilter keyFilter;

    protected AbstractKVNavigableSet(KVStore kv, boolean prefixMode) {
        this(kv, prefixMode, (KeyRange)null);
    }

    protected AbstractKVNavigableSet(KVStore kv, boolean prefixMode, byte[] prefix) {
        this(kv, prefixMode, KeyRange.forPrefix(prefix));
    }

    protected AbstractKVNavigableSet(KVStore kv, boolean prefixMode, KeyRange keyRange) {
        this(kv, prefixMode, false, keyRange, null, new Bounds());
    }

    protected AbstractKVNavigableSet(KVStore kv, boolean prefixMode, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<E> bounds) {
        super(bounds);
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
        this.prefixMode = prefixMode;
        this.reversed = reversed;
        this.keyRange = keyRange;
        this.keyFilter = keyFilter;
    }

    public boolean contains(Object obj) {
        byte[] key = this.encodeVisible(obj, false);
        if (key == null) {
            return false;
        }
        if (this.prefixMode) {
            byte[] maxKey;
            try {
                maxKey = ByteUtil.getKeyAfterPrefix((byte[])key);
            }
            catch (IllegalArgumentException e) {
                maxKey = null;
            }
            KVPair pair = this.kv.getAtLeast(key, maxKey);
            if (pair == null) {
                return false;
            }
            assert (ByteUtil.isPrefixOf((byte[])key, (byte[])pair.getKey()));
            return true;
        }
        return this.kv.get(key) != null;
    }

    public CloseableIterator<E> iterator() {
        return new AbstractKVIterator<E>(this.kv, this.prefixMode, this.reversed, this.keyRange, this.keyFilter){

            @Override
            protected E decodePair(KVPair pair, ByteReader keyReader) {
                return AbstractKVNavigableSet.this.decode(keyReader);
            }

            @Override
            protected void doRemove(E value, KVPair pair) {
                AbstractKVNavigableSet.this.remove(value);
            }
        };
    }

    public NavigableSet<E> filterKeys(KeyFilter keyFilter) {
        Preconditions.checkArgument((keyFilter != null ? 1 : 0) != 0, (Object)"null keyFilter");
        if (this.keyFilter != null) {
            keyFilter = KeyFilterUtil.intersection(keyFilter, this.keyFilter);
        }
        return this.createSubSet(this.reversed, this.keyRange, keyFilter, this.bounds);
    }

    protected boolean isWithinLowerBound(E elem) {
        if (!super.isWithinLowerBound(elem)) {
            return false;
        }
        if (this.keyRange == null) {
            return true;
        }
        ByteWriter writer = new ByteWriter();
        this.encode(writer, elem);
        return KeyRange.compare(writer.getBytes(), this.keyRange.getMin()) >= 0;
    }

    protected boolean isWithinUpperBound(E elem) {
        if (!super.isWithinUpperBound(elem)) {
            return false;
        }
        if (this.keyRange == null) {
            return true;
        }
        ByteWriter writer = new ByteWriter();
        this.encode(writer, elem);
        return KeyRange.compare(writer.getBytes(), this.keyRange.getMax()) < 0;
    }

    protected final NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds) {
        boolean newReversed = this.reversed ^ reverse;
        KeyRange newKeyRange = this.buildKeyRange(newReversed ? newBounds.reverse() : newBounds);
        return this.createSubSet(newReversed, newKeyRange, this.keyFilter, newBounds);
    }

    protected abstract NavigableSet<E> createSubSet(boolean var1, KeyRange var2, KeyFilter var3, Bounds<E> var4);

    protected abstract void encode(ByteWriter var1, Object var2);

    protected abstract E decode(ByteReader var1);

    protected boolean isVisible(byte[] key) {
        return !(this.keyRange != null && !this.keyRange.contains(key) || this.keyFilter != null && !this.keyFilter.contains(key));
    }

    protected byte[] encodeVisible(Object obj, boolean fail) {
        ByteWriter writer = new ByteWriter();
        try {
            this.encode(writer, obj);
        }
        catch (IllegalArgumentException e) {
            if (!fail) {
                return null;
            }
            throw e;
        }
        byte[] key = writer.getBytes();
        if (this.keyRange != null && !this.keyRange.contains(key)) {
            if (fail) {
                throw new IllegalArgumentException("value is out of bounds: " + obj);
            }
            return null;
        }
        if (this.keyFilter != null && !this.keyFilter.contains(key)) {
            if (fail) {
                throw new IllegalArgumentException("value is filtered out: " + obj);
            }
            return null;
        }
        return key;
    }

    private KeyRange buildKeyRange(Bounds<E> bounds) {
        byte[] newMaxKey;
        ByteWriter writer;
        byte[] newMinKey;
        byte[] minKey = this.keyRange != null ? this.keyRange.getMin() : null;
        byte[] maxKey = this.keyRange != null ? this.keyRange.getMax() : null;
        switch (bounds.getLowerBoundType()) {
            case NONE: {
                newMinKey = minKey;
                break;
            }
            default: {
                writer = new ByteWriter();
                this.encode(writer, bounds.getLowerBound());
                newMinKey = writer.getBytes();
                if (!bounds.getLowerBoundType().isInclusive().booleanValue()) {
                    byte[] byArray = newMinKey = this.prefixMode ? ByteUtil.getKeyAfterPrefix((byte[])newMinKey) : ByteUtil.getNextKey((byte[])newMinKey);
                }
                if (minKey != null) {
                    newMinKey = ByteUtil.max((byte[])newMinKey, (byte[])minKey);
                }
                if (maxKey == null) break;
                newMinKey = ByteUtil.min((byte[])newMinKey, (byte[])maxKey);
            }
        }
        switch (bounds.getUpperBoundType()) {
            case NONE: {
                newMaxKey = maxKey;
                break;
            }
            default: {
                writer = new ByteWriter();
                this.encode(writer, bounds.getUpperBound());
                newMaxKey = writer.getBytes();
                if (bounds.getUpperBoundType().isInclusive().booleanValue()) {
                    byte[] byArray = newMaxKey = this.prefixMode ? ByteUtil.getKeyAfterPrefix((byte[])newMaxKey) : ByteUtil.getNextKey((byte[])newMaxKey);
                }
                if (maxKey != null) {
                    newMaxKey = ByteUtil.min((byte[])newMaxKey, (byte[])maxKey);
                }
                if (minKey == null) break;
                newMaxKey = ByteUtil.max((byte[])newMaxKey, (byte[])minKey);
            }
        }
        return new KeyRange(newMinKey != null ? newMinKey : ByteUtil.EMPTY, newMaxKey);
    }
}

