/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.AbstractKVNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public class KVNavigableSet
extends AbstractKVNavigableSet<byte[]> {
    public KVNavigableSet(KVStore kv) {
        this(kv, false, null, null);
    }

    public KVNavigableSet(KVStore kv, byte[] prefix) {
        this(kv, false, KeyRange.forPrefix(prefix), null);
    }

    protected KVNavigableSet(KVStore kv, boolean reversed, KeyRange keyRange, KeyFilter keyFilter) {
        this(kv, reversed, keyRange, keyFilter, KVNavigableSet.createBounds(keyRange));
    }

    private KVNavigableSet(KVStore kv, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<byte[]> bounds) {
        super(kv, false, reversed, keyRange, keyFilter, bounds);
    }

    public Comparator<byte[]> comparator() {
        return this.reversed ? Collections.reverseOrder(ByteUtil.COMPARATOR) : ByteUtil.COMPARATOR;
    }

    public boolean remove(Object obj) {
        if (!(obj instanceof byte[])) {
            return false;
        }
        byte[] key = (byte[])obj;
        if (!this.isVisible(key)) {
            return false;
        }
        byte[] value = this.kv.get(key);
        if (value == null) {
            return false;
        }
        this.kv.remove(key);
        return true;
    }

    public void clear() {
        if (this.keyFilter != null) {
            throw new UnsupportedOperationException("clear() not supported when KeyFilter configured");
        }
        byte[] minKey = this.keyRange != null ? this.keyRange.getMin() : null;
        byte[] maxKey = this.keyRange != null ? this.keyRange.getMax() : null;
        this.kv.removeRange(minKey, maxKey);
    }

    @Override
    protected void encode(ByteWriter writer, Object obj) {
        Preconditions.checkArgument((boolean)(obj instanceof byte[]), (Object)"value is not a byte[]");
        writer.write((byte[])obj);
    }

    @Override
    protected byte[] decode(ByteReader reader) {
        return reader.getBytes();
    }

    @Override
    protected NavigableSet<byte[]> createSubSet(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<byte[]> newBounds) {
        return new KVNavigableSet(this.kv, newReversed, newKeyRange, newKeyFilter, newBounds);
    }

    static Bounds<byte[]> createBounds(KeyRange keyRange) {
        return keyRange != null ? new Bounds((Object)keyRange.getMin(), (Object)keyRange.getMax()) : new Bounds();
    }
}

