/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.UnsignedIntEncoder;

public final class KeyListEncoder {
    private KeyListEncoder() {
    }

    public static void write(OutputStream out, byte[] key, byte[] prev) throws IOException {
        int prefixLength;
        Preconditions.checkArgument((out != null ? 1 : 0) != 0, (Object)"null out");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (prev != null) {
            for (prefixLength = 0; prefixLength < key.length && prefixLength < prev.length && key[prefixLength] == prev[prefixLength]; ++prefixLength) {
            }
        }
        if (prefixLength > 1) {
            int suffixLength = key.length - prefixLength;
            LongEncoder.write((OutputStream)out, (long)(~(prefixLength - 2)));
            UnsignedIntEncoder.write((OutputStream)out, (int)suffixLength);
            out.write(key, prefixLength, suffixLength);
        } else {
            LongEncoder.write((OutputStream)out, (long)key.length);
            out.write(key);
        }
    }

    public static int writeLength(byte[] key, byte[] prev) {
        int prefixLength;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (prev != null) {
            for (prefixLength = 0; prefixLength < key.length && prefixLength < prev.length && key[prefixLength] == prev[prefixLength]; ++prefixLength) {
            }
        }
        if (prefixLength > 1) {
            int suffixLength = key.length - prefixLength;
            return LongEncoder.encodeLength((long)(~(prefixLength - 2))) + UnsignedIntEncoder.encodeLength((int)suffixLength) + suffixLength;
        }
        return LongEncoder.encodeLength((long)key.length) + key.length;
    }

    public static byte[] read(InputStream input, byte[] prev) throws IOException {
        byte[] key;
        int prefixLength;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        int keyLength = KeyListEncoder.readSignedInt(input);
        if (keyLength < 0) {
            if (prev == null) {
                throw new IllegalArgumentException("null `prev' given but next key has " + -keyLength + " byte shared prefix");
            }
            prefixLength = ~keyLength + 2;
            int suffixLength = UnsignedIntEncoder.read((InputStream)input);
            if ((keyLength = prefixLength + suffixLength) < 0) {
                throw new IllegalArgumentException("invalid prefix length " + prefixLength + " plus suffix length " + suffixLength);
            }
            key = new byte[keyLength];
            System.arraycopy(prev, 0, key, 0, prefixLength);
        } else {
            key = new byte[keyLength];
            prefixLength = 0;
        }
        while (prefixLength < key.length) {
            int num = input.read(key, prefixLength, key.length - prefixLength);
            if (num == -1) {
                throw new EOFException();
            }
            prefixLength += num;
        }
        return key;
    }

    public static void writePairs(Iterator<KVPair> kvpairs, OutputStream output) throws IOException {
        Preconditions.checkArgument((kvpairs != null ? 1 : 0) != 0, (Object)"null kvpairs");
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        byte[] prev = null;
        while (kvpairs.hasNext()) {
            KVPair kv = kvpairs.next();
            byte[] key = kv.getKey();
            byte[] value = kv.getValue();
            KeyListEncoder.write(output, key, prev);
            KeyListEncoder.write(output, value, null);
            prev = key;
        }
        output.write(255);
    }

    public static long writePairsLength(Iterator<KVPair> kvpairs) {
        long total = 1L;
        byte[] prev = null;
        while (kvpairs.hasNext()) {
            KVPair kv = kvpairs.next();
            byte[] key = kv.getKey();
            byte[] value = kv.getValue();
            total += (long)KeyListEncoder.writeLength(key, prev);
            total += (long)KeyListEncoder.writeLength(value, null);
            prev = key;
        }
        return total;
    }

    public static Iterator<KVPair> readPairs(final InputStream input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        return new AbstractIterator<KVPair>(){
            private final BufferedInputStream in;
            private byte[] prev;
            {
                this.in = new BufferedInputStream(input, 1024);
            }

            protected KVPair computeNext() {
                try {
                    this.in.mark(1);
                    int b = this.in.read();
                    if (b == -1) {
                        throw new EOFException("truncated input");
                    }
                    if (b == 255) {
                        return (KVPair)this.endOfData();
                    }
                    this.in.reset();
                    byte[] key = KeyListEncoder.read(this.in, this.prev);
                    byte[] value = KeyListEncoder.read(this.in, null);
                    this.prev = key;
                    return new KVPair(key, value);
                }
                catch (IOException e) {
                    throw new RuntimeException("I/O error during iteration", e);
                }
            }
        };
    }

    private static int readSignedInt(InputStream input) throws IOException {
        long longValue = LongEncoder.read((InputStream)input);
        int intValue = (int)longValue;
        Preconditions.checkArgument((intValue == (int)longValue ? 1 : 0) != 0, (String)"read out-of-range encoded int value %s", (long)longValue);
        return intValue;
    }
}

