/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.util.PrefixKVTransaction;

public class PrefixKVDatabase
implements KVDatabase {
    private final KVDatabase db;
    private final byte[] keyPrefix;

    public PrefixKVDatabase(KVDatabase db, byte[] keyPrefix) {
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"null db");
        Preconditions.checkArgument((keyPrefix != null ? 1 : 0) != 0, (Object)"null keyPrefix");
        this.db = db;
        this.keyPrefix = (byte[])keyPrefix.clone();
    }

    public KVDatabase getContainingKVDatabase() {
        return this.db;
    }

    public final byte[] getKeyPrefix() {
        return (byte[])this.keyPrefix.clone();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public PrefixKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction();
    }

    @Override
    public PrefixKVTransaction createTransaction() {
        return new PrefixKVTransaction(this);
    }
}

