/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Bytes;
import java.util.Iterator;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

public abstract class PrefixKVStore
extends ForwardingKVStore {
    private final byte[] keyPrefix;

    public PrefixKVStore(byte[] keyPrefix) {
        Preconditions.checkArgument((keyPrefix != null ? 1 : 0) != 0, (Object)"null keyPrefix");
        this.keyPrefix = (byte[])keyPrefix.clone();
    }

    public final byte[] getKeyPrefix() {
        return (byte[])this.keyPrefix.clone();
    }

    public static PrefixKVStore create(final KVStore kvstore, byte[] keyPrefix) {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        Preconditions.checkArgument((keyPrefix != null ? 1 : 0) != 0, (Object)"null keyPrefix");
        return new PrefixKVStore(keyPrefix){

            @Override
            protected KVStore delegate() {
                return kvstore;
            }
        };
    }

    @Override
    public byte[] get(byte[] key) {
        return this.delegate().get(this.addPrefix(key));
    }

    @Override
    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        KVPair pair = this.delegate().getAtLeast(this.addMinPrefix(minKey), this.addMaxPrefix(maxKey));
        if (pair == null) {
            return null;
        }
        assert (ByteUtil.isPrefixOf((byte[])this.keyPrefix, (byte[])pair.getKey()));
        return new KVPair(this.removePrefix(pair.getKey()), pair.getValue());
    }

    @Override
    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        KVPair pair = this.delegate().getAtMost(this.addMaxPrefix(maxKey), this.addMinPrefix(minKey));
        if (pair == null) {
            return null;
        }
        assert (ByteUtil.isPrefixOf((byte[])this.keyPrefix, (byte[])pair.getKey()));
        return new KVPair(this.removePrefix(pair.getKey()), pair.getValue());
    }

    @Override
    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        CloseableIterator<KVPair> i = this.delegate().getRange(this.addMinPrefix(minKey), this.addMaxPrefix(maxKey), reverse);
        return CloseableIterator.wrap((Iterator)Iterators.transform(i, pair -> new KVPair(this.removePrefix(pair.getKey()), pair.getValue())), i);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.delegate().put(this.addPrefix(key), value);
    }

    @Override
    public void remove(byte[] key) {
        this.delegate().remove(this.addPrefix(key));
    }

    @Override
    public void removeRange(byte[] minKey, byte[] maxKey) {
        this.delegate().removeRange(this.addMinPrefix(minKey), this.addMaxPrefix(maxKey));
    }

    @Override
    public void adjustCounter(byte[] key, long amount) {
        this.delegate().adjustCounter(this.addPrefix(key), amount);
    }

    private byte[] addPrefix(byte[] key) {
        if (key == null) {
            return null;
        }
        return Bytes.concat((byte[][])new byte[][]{this.keyPrefix, key});
    }

    private byte[] addMinPrefix(byte[] minKey) {
        if (minKey == null) {
            return (byte[])this.keyPrefix.clone();
        }
        return this.addPrefix(minKey);
    }

    private byte[] addMaxPrefix(byte[] maxKey) {
        if (maxKey == null) {
            return this.keyPrefix.length > 0 ? ByteUtil.getKeyAfterPrefix((byte[])this.keyPrefix) : null;
        }
        return this.addPrefix(maxKey);
    }

    private byte[] removePrefix(byte[] key) {
        if (!ByteUtil.isPrefixOf((byte[])this.keyPrefix, (byte[])key)) {
            throw new IllegalArgumentException("read key " + ByteUtil.toString((byte[])key) + " not having " + ByteUtil.toString((byte[])this.keyPrefix) + " as a prefix");
        }
        byte[] suffix = new byte[key.length - this.keyPrefix.length];
        System.arraycopy(key, this.keyPrefix.length, suffix, 0, suffix.length);
        return suffix;
    }
}

