/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.util.concurrent.Future;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.util.CloseableForwardingKVStore;
import org.jsimpledb.kv.util.PrefixKVDatabase;
import org.jsimpledb.kv.util.PrefixKVStore;

public class PrefixKVTransaction
extends PrefixKVStore
implements KVTransaction {
    private final KVTransaction tx;
    private final PrefixKVDatabase db;

    public PrefixKVTransaction(KVTransaction tx, byte[] keyPrefix) {
        this(tx, keyPrefix, null);
    }

    PrefixKVTransaction(PrefixKVDatabase db) {
        this(db.getContainingKVDatabase().createTransaction(), db.getKeyPrefix(), db);
    }

    private PrefixKVTransaction(KVTransaction tx, byte[] keyPrefix, PrefixKVDatabase db) {
        super(keyPrefix);
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        this.tx = tx;
        this.db = db;
    }

    @Override
    protected KVTransaction delegate() {
        return this.tx;
    }

    @Override
    public PrefixKVDatabase getKVDatabase() {
        if (this.db == null) {
            throw new UnsupportedOperationException("instance was not created from a PrefixKVDatabase");
        }
        return this.db;
    }

    @Override
    public void setTimeout(long timeout) {
        this.delegate().setTimeout(timeout);
    }

    @Override
    public Future<Void> watchKey(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        return this.delegate().watchKey(Bytes.concat((byte[][])new byte[][]{this.db.getKeyPrefix(), key}));
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate().isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.delegate().setReadOnly(readOnly);
    }

    @Override
    public void commit() {
        this.delegate().commit();
    }

    @Override
    public void rollback() {
        this.delegate().rollback();
    }

    @Override
    public CloseableKVStore mutableSnapshot() {
        CloseableKVStore kvstore = this.tx.mutableSnapshot();
        return new CloseableForwardingKVStore(PrefixKVStore.create(kvstore, this.getKeyPrefix()), kvstore);
    }
}

