/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.util;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.xml.IndentXMLStreamWriter;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.util.AbstractXMLStreaming;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;

public class XMLSerializer
extends AbstractXMLStreaming {
    public static final QName ENTRIES_TAG = new QName("entries");
    public static final QName ENTRY_TAG = new QName("entry");
    public static final QName KEY_TAG = new QName("key");
    public static final QName VALUE_TAG = new QName("value");
    private final KVStore kv;

    public XMLSerializer(KVStore kv) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        this.kv = kv;
    }

    public int read(InputStream input) throws XMLStreamException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        return this.read(XMLInputFactory.newFactory().createXMLStreamReader(input));
    }

    public int read(XMLStreamReader reader) throws XMLStreamException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"null reader");
        this.expect(reader, false, new QName[]{ENTRIES_TAG});
        int count = 0;
        while (this.expect(reader, true, new QName[]{ENTRY_TAG})) {
            byte[] key;
            this.expect(reader, false, new QName[]{KEY_TAG});
            try {
                key = ByteUtil.parse((String)reader.getElementText());
            }
            catch (IllegalArgumentException e) {
                throw new XMLStreamException("invalid hexadecimal key", reader.getLocation(), e);
            }
            if (!this.expect(reader, true, new QName[]{VALUE_TAG})) {
                this.kv.put(key, ByteUtil.EMPTY);
            } else {
                byte[] value;
                try {
                    value = ByteUtil.parse((String)reader.getElementText());
                }
                catch (IllegalArgumentException e) {
                    throw new XMLStreamException("invalid hexadecimal value", reader.getLocation(), e);
                }
                this.kv.put(key, value);
                this.expectClose(reader);
            }
            ++count;
        }
        return count;
    }

    public int write(OutputStream output, boolean indent) throws XMLStreamException {
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "UTF-8");
        if (indent) {
            xmlWriter = new IndentXMLStreamWriter(xmlWriter);
        }
        xmlWriter.writeStartDocument("UTF-8", "1.0");
        return this.write(xmlWriter, null, null);
    }

    public int write(Writer writer, boolean indent) throws XMLStreamException {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
        if (indent) {
            xmlWriter = new IndentXMLStreamWriter(xmlWriter);
        }
        xmlWriter.writeStartDocument("1.0");
        return this.write(xmlWriter, null, null);
    }

    public int write(XMLStreamWriter writer, byte[] minKey, byte[] maxKey) throws XMLStreamException {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        writer.setDefaultNamespace(ENTRIES_TAG.getNamespaceURI());
        writer.writeStartElement(ENTRIES_TAG.getNamespaceURI(), ENTRIES_TAG.getLocalPart());
        int count = 0;
        try (CloseableIterator<KVPair> i = this.kv.getRange(minKey, maxKey);){
            while (i.hasNext()) {
                writer.writeStartElement(ENTRY_TAG.getNamespaceURI(), ENTRY_TAG.getLocalPart());
                KVPair pair = (KVPair)i.next();
                this.writeElement(writer, KEY_TAG, pair.getKey());
                byte[] value = pair.getValue();
                if (value.length > 0) {
                    this.writeElement(writer, VALUE_TAG, value);
                }
                writer.writeEndElement();
                ++count;
            }
        }
        writer.writeEndElement();
        writer.flush();
        return count;
    }

    private void writeElement(XMLStreamWriter writer, QName element, byte[] value) throws XMLStreamException {
        this.writeElement(writer, element, ByteUtil.toString((byte[])value));
    }
}

